/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.qos.api.BaseCommand;
import org.apache.dubbo.qos.api.Cmd;
import org.apache.dubbo.qos.api.CommandContext;
import org.apache.dubbo.qos.api.PermissionLevel;
import org.apache.dubbo.remoting.http12.rest.OpenAPIRequest;
import org.apache.dubbo.remoting.http12.rest.OpenAPIService;
import org.apache.dubbo.rpc.model.FrameworkModel;

@Cmd(name="getOpenAPI", summary="Get the openapi descriptor for specified services.", example={"getOpenAPI", "getOpenAPI groupA", "getOpenAPI com.example.DemoService", "getOpenAPI --group groupA --version 1.1.0 --tag tagA --service com.example. --openapi 3.0.0 --format yaml"}, requiredPermissionLevel=PermissionLevel.PRIVATE)
public class GetOpenAPI
implements BaseCommand {
    private final FrameworkModel frameworkModel;

    public GetOpenAPI(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        OpenAPIService openAPIService = this.frameworkModel.getBean(OpenAPIService.class);
        if (openAPIService == null) {
            return "OpenAPI is not available";
        }
        OpenAPIRequest request = new OpenAPIRequest();
        int len = args.length;
        if (len > 0) {
            if (len == 1) {
                String arg0 = args[0];
                if (arg0.indexOf(46) > 0) {
                    request.setService(new String[]{arg0});
                } else {
                    request.setGroup(arg0);
                }
            } else {
                block16: for (int i = 0; i < len; i += 2) {
                    String value = args[i + 1];
                    switch (StringUtils.substringAfterLast(args[i], 45)) {
                        case "group": {
                            request.setGroup(value);
                            continue block16;
                        }
                        case "version": {
                            request.setVersion(value);
                            continue block16;
                        }
                        case "tag": {
                            request.setTag(StringUtils.tokenize(value, new char[0]));
                            continue block16;
                        }
                        case "service": {
                            request.setService(StringUtils.tokenize(value, new char[0]));
                            continue block16;
                        }
                        case "openapi": {
                            request.setOpenapi(value);
                            continue block16;
                        }
                        case "format": {
                            request.setFormat(value);
                            continue block16;
                        }
                    }
                }
            }
        }
        return openAPIService.getDocument(request);
    }
}

