/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command;

import java.util.Arrays;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.qos.api.BaseCommand;
import org.apache.dubbo.qos.api.CommandContext;
import org.apache.dubbo.qos.command.ActuatorExecutor;
import org.apache.dubbo.qos.command.CommandContextFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ActuatorCommandExecutor
implements ActuatorExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ActuatorCommandExecutor.class);
    private final ApplicationModel applicationModel;

    public ActuatorCommandExecutor(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    @Override
    public String execute(String commandName, String[] parameters) {
        CommandContext commandContext;
        if (parameters == null || parameters.length == 0) {
            commandContext = CommandContextFactory.newInstance(commandName);
            commandContext.setHttp(true);
        } else {
            commandContext = CommandContextFactory.newInstance(commandName, parameters, true);
        }
        logger.info("[Dubbo Actuator QoS] Command Process start. Command: " + commandContext.getCommandName() + ", Args: " + Arrays.toString(commandContext.getArgs()));
        try {
            BaseCommand command = this.applicationModel.getExtensionLoader(BaseCommand.class).getExtension(commandContext.getCommandName());
            return command.execute(commandContext, commandContext.getArgs());
        }
        catch (Throwable t) {
            logger.info("[Dubbo Actuator QoS] Command Process Failed. Command: " + commandContext.getCommandName() + ", Args: " + Arrays.toString(commandContext.getArgs()), t);
            throw t;
        }
    }
}

