/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.netty.shaded.io.netty.handler.codec.quic;

import java.net.InetSocketAddress;
import org.apache.dubbo.netty.shaded.io.netty.buffer.ByteBuf;
import org.apache.dubbo.netty.shaded.io.netty.channel.epoll.SegmentedDatagramPacket;
import org.apache.dubbo.netty.shaded.io.netty.channel.socket.DatagramPacket;
import org.apache.dubbo.netty.shaded.io.netty.handler.codec.quic.SegmentedDatagramPacketAllocator;
import org.apache.dubbo.netty.shaded.io.netty.util.internal.ObjectUtil;

public final class EpollQuicUtils {
    private EpollQuicUtils() {
    }

    public static SegmentedDatagramPacketAllocator newSegmentedAllocator(int maxNumSegments) {
        ObjectUtil.checkInRange(maxNumSegments, 1, 64, "maxNumSegments");
        if (SegmentedDatagramPacket.isSupported()) {
            return new EpollSegmentedDatagramPacketAllocator(maxNumSegments);
        }
        return SegmentedDatagramPacketAllocator.NONE;
    }

    private static final class EpollSegmentedDatagramPacketAllocator
    implements SegmentedDatagramPacketAllocator {
        private final int maxNumSegments;

        EpollSegmentedDatagramPacketAllocator(int maxNumSegments) {
            this.maxNumSegments = maxNumSegments;
        }

        @Override
        public int maxNumSegments() {
            return this.maxNumSegments;
        }

        @Override
        public DatagramPacket newPacket(ByteBuf buffer, int segmentSize, InetSocketAddress remoteAddress) {
            return new org.apache.dubbo.netty.shaded.io.netty.channel.unix.SegmentedDatagramPacket(buffer, segmentSize, remoteAddress);
        }
    }
}

