/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.netty.shaded.io.netty.handler.codec.mqtt;

public final class MqttReasonCodes {
    private MqttReasonCodes() {
    }

    private static <E> E valueOfHelper(byte b, E[] values) {
        try {
            return values[b & 0xFF];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("unknown reason code: " + b);
        }
    }

    public static enum UnsubAck {
        SUCCESS(0),
        NO_SUBSCRIPTION_EXISTED(17),
        UNSPECIFIED_ERROR(-128),
        IMPLEMENTATION_SPECIFIC_ERROR(-125),
        NOT_AUTHORIZED(-121),
        TOPIC_FILTER_INVALID(-113),
        PACKET_IDENTIFIER_IN_USE(-111);

        private static final UnsubAck[] VALUES;
        private final byte byteValue;

        private UnsubAck(byte byteValue) {
            this.byteValue = byteValue;
        }

        public byte byteValue() {
            return this.byteValue;
        }

        public static UnsubAck valueOf(byte b) {
            return (UnsubAck)((Object)MqttReasonCodes.valueOfHelper(b, (Object[])UnsubAck.VALUES));
        }

        static {
            UnsubAck[] values = UnsubAck.values();
            VALUES = new UnsubAck[146];
            for (UnsubAck code : values) {
                int unsignedByte = code.byteValue & 0xFF;
                UnsubAck.VALUES[unsignedByte] = code;
            }
        }
    }

    public static enum SubAck {
        GRANTED_QOS_0(0),
        GRANTED_QOS_1(1),
        GRANTED_QOS_2(2),
        UNSPECIFIED_ERROR(-128),
        IMPLEMENTATION_SPECIFIC_ERROR(-125),
        NOT_AUTHORIZED(-121),
        TOPIC_FILTER_INVALID(-113),
        PACKET_IDENTIFIER_IN_USE(-111),
        QUOTA_EXCEEDED(-105),
        SHARED_SUBSCRIPTIONS_NOT_SUPPORTED(-98),
        SUBSCRIPTION_IDENTIFIERS_NOT_SUPPORTED(-95),
        WILDCARD_SUBSCRIPTIONS_NOT_SUPPORTED(-94);

        private static final SubAck[] VALUES;
        private final byte byteValue;

        private SubAck(byte byteValue) {
            this.byteValue = byteValue;
        }

        public byte byteValue() {
            return this.byteValue;
        }

        public static SubAck valueOf(byte b) {
            return (SubAck)((Object)MqttReasonCodes.valueOfHelper(b, (Object[])SubAck.VALUES));
        }

        static {
            SubAck[] values = SubAck.values();
            VALUES = new SubAck[163];
            for (SubAck code : values) {
                int unsignedByte = code.byteValue & 0xFF;
                SubAck.VALUES[unsignedByte] = code;
            }
        }
    }

    public static enum PubComp {
        SUCCESS(0),
        PACKET_IDENTIFIER_NOT_FOUND(-110);

        private static final PubComp[] VALUES;
        private final byte byteValue;

        private PubComp(byte byteValue) {
            this.byteValue = byteValue;
        }

        public byte byteValue() {
            return this.byteValue;
        }

        public static PubComp valueOf(byte b) {
            return (PubComp)((Object)MqttReasonCodes.valueOfHelper(b, (Object[])PubComp.VALUES));
        }

        static {
            PubComp[] values = PubComp.values();
            VALUES = new PubComp[147];
            for (PubComp code : values) {
                int unsignedByte = code.byteValue & 0xFF;
                PubComp.VALUES[unsignedByte] = code;
            }
        }
    }

    public static enum PubRel {
        SUCCESS(0),
        PACKET_IDENTIFIER_NOT_FOUND(-110);

        private static final PubRel[] VALUES;
        private final byte byteValue;

        private PubRel(byte byteValue) {
            this.byteValue = byteValue;
        }

        public byte byteValue() {
            return this.byteValue;
        }

        public static PubRel valueOf(byte b) {
            return (PubRel)((Object)MqttReasonCodes.valueOfHelper(b, (Object[])PubRel.VALUES));
        }

        static {
            PubRel[] values = PubRel.values();
            VALUES = new PubRel[147];
            for (PubRel code : values) {
                int unsignedByte = code.byteValue & 0xFF;
                PubRel.VALUES[unsignedByte] = code;
            }
        }
    }

    public static enum PubRec {
        SUCCESS(0),
        NO_MATCHING_SUBSCRIBERS(16),
        UNSPECIFIED_ERROR(-128),
        IMPLEMENTATION_SPECIFIC_ERROR(-125),
        NOT_AUTHORIZED(-121),
        TOPIC_NAME_INVALID(-112),
        PACKET_IDENTIFIER_IN_USE(-111),
        QUOTA_EXCEEDED(-105),
        PAYLOAD_FORMAT_INVALID(-103);

        private static final PubRec[] VALUES;
        private final byte byteValue;

        private PubRec(byte byteValue) {
            this.byteValue = byteValue;
        }

        public byte byteValue() {
            return this.byteValue;
        }

        public static PubRec valueOf(byte b) {
            return (PubRec)((Object)MqttReasonCodes.valueOfHelper(b, (Object[])PubRec.VALUES));
        }

        static {
            PubRec[] values = PubRec.values();
            VALUES = new PubRec[154];
            for (PubRec code : values) {
                int unsignedByte = code.byteValue & 0xFF;
                PubRec.VALUES[unsignedByte] = code;
            }
        }
    }

    public static enum PubAck {
        SUCCESS(0),
        NO_MATCHING_SUBSCRIBERS(16),
        UNSPECIFIED_ERROR(-128),
        IMPLEMENTATION_SPECIFIC_ERROR(-125),
        NOT_AUTHORIZED(-121),
        TOPIC_NAME_INVALID(-112),
        PACKET_IDENTIFIER_IN_USE(-111),
        QUOTA_EXCEEDED(-105),
        PAYLOAD_FORMAT_INVALID(-103);

        private static final PubAck[] VALUES;
        private final byte byteValue;

        private PubAck(byte byteValue) {
            this.byteValue = byteValue;
        }

        public byte byteValue() {
            return this.byteValue;
        }

        public static PubAck valueOf(byte b) {
            return (PubAck)((Object)MqttReasonCodes.valueOfHelper(b, (Object[])PubAck.VALUES));
        }

        static {
            PubAck[] values = PubAck.values();
            VALUES = new PubAck[154];
            for (PubAck code : values) {
                int unsignedByte = code.byteValue & 0xFF;
                PubAck.VALUES[unsignedByte] = code;
            }
        }
    }

    public static enum Auth {
        SUCCESS(0),
        CONTINUE_AUTHENTICATION(24),
        REAUTHENTICATE(25);

        private static final Auth[] VALUES;
        private final byte byteValue;

        private Auth(byte byteValue) {
            this.byteValue = byteValue;
        }

        public byte byteValue() {
            return this.byteValue;
        }

        public static Auth valueOf(byte b) {
            return (Auth)((Object)MqttReasonCodes.valueOfHelper(b, (Object[])Auth.VALUES));
        }

        static {
            Auth[] values = Auth.values();
            VALUES = new Auth[26];
            for (Auth code : values) {
                int unsignedByte = code.byteValue & 0xFF;
                Auth.VALUES[unsignedByte] = code;
            }
        }
    }

    public static enum Disconnect {
        NORMAL_DISCONNECT(0),
        DISCONNECT_WITH_WILL_MESSAGE(4),
        UNSPECIFIED_ERROR(-128),
        MALFORMED_PACKET(-127),
        PROTOCOL_ERROR(-126),
        IMPLEMENTATION_SPECIFIC_ERROR(-125),
        NOT_AUTHORIZED(-121),
        SERVER_BUSY(-119),
        SERVER_SHUTTING_DOWN(-117),
        KEEP_ALIVE_TIMEOUT(-115),
        SESSION_TAKEN_OVER(-114),
        TOPIC_FILTER_INVALID(-113),
        TOPIC_NAME_INVALID(-112),
        RECEIVE_MAXIMUM_EXCEEDED(-109),
        TOPIC_ALIAS_INVALID(-108),
        PACKET_TOO_LARGE(-107),
        MESSAGE_RATE_TOO_HIGH(-106),
        QUOTA_EXCEEDED(-105),
        ADMINISTRATIVE_ACTION(-104),
        PAYLOAD_FORMAT_INVALID(-103),
        RETAIN_NOT_SUPPORTED(-102),
        QOS_NOT_SUPPORTED(-101),
        USE_ANOTHER_SERVER(-100),
        SERVER_MOVED(-99),
        SHARED_SUBSCRIPTIONS_NOT_SUPPORTED(-98),
        CONNECTION_RATE_EXCEEDED(-97),
        MAXIMUM_CONNECT_TIME(-96),
        SUBSCRIPTION_IDENTIFIERS_NOT_SUPPORTED(-95),
        WILDCARD_SUBSCRIPTIONS_NOT_SUPPORTED(-94);

        protected static final Disconnect[] VALUES;
        private final byte byteValue;

        private Disconnect(byte byteValue) {
            this.byteValue = byteValue;
        }

        public byte byteValue() {
            return this.byteValue;
        }

        public static Disconnect valueOf(byte b) {
            return (Disconnect)((Object)MqttReasonCodes.valueOfHelper(b, (Object[])Disconnect.VALUES));
        }

        static {
            Disconnect[] values = Disconnect.values();
            VALUES = new Disconnect[163];
            for (Disconnect code : values) {
                int unsignedByte = code.byteValue & 0xFF;
                Disconnect.VALUES[unsignedByte] = code;
            }
        }
    }
}

