/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.netty.shaded.io.netty.channel.uring;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.dubbo.netty.shaded.io.netty.channel.uring.Native;
import org.apache.dubbo.netty.shaded.io.netty.util.internal.PlatformDependent;

final class SockaddrIn {
    static final byte[] IPV4_MAPPED_IPV6_PREFIX = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1};
    static final int IPV4_ADDRESS_LENGTH = 4;
    static final int IPV6_ADDRESS_LENGTH = 16;
    static final byte[] SOCKADDR_IN6_EMPTY_ARRAY = new byte[Native.SIZEOF_SOCKADDR_IN6];
    static final byte[] SOCKADDR_IN_EMPTY_ARRAY = new byte[Native.SIZEOF_SOCKADDR_IN];

    private SockaddrIn() {
    }

    static int set(boolean ipv6, ByteBuffer memory, InetSocketAddress address) {
        if (ipv6) {
            return SockaddrIn.setIPv6(memory, address.getAddress(), address.getPort());
        }
        return SockaddrIn.setIPv4(memory, address.getAddress(), address.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int setIPv4(ByteBuffer memory, InetAddress address, int port) {
        int position = memory.position();
        memory.mark();
        try {
            memory.put(SOCKADDR_IN_EMPTY_ARRAY);
            memory.putShort(position + Native.SOCKADDR_IN_OFFSETOF_SIN_FAMILY, Native.AF_INET);
            memory.putShort(position + Native.SOCKADDR_IN_OFFSETOF_SIN_PORT, SockaddrIn.handleNetworkOrder(memory.order(), (short)port));
            byte[] bytes = address.getAddress();
            int offset = 0;
            if (bytes.length == 16) {
                offset = IPV4_MAPPED_IPV6_PREFIX.length;
            }
            assert (bytes.length == offset + 4);
            memory.position(position + Native.SOCKADDR_IN_OFFSETOF_SIN_ADDR + Native.IN_ADDRESS_OFFSETOF_S_ADDR);
            memory.put(bytes, offset, 4);
            int n = Native.SIZEOF_SOCKADDR_IN;
            return n;
        }
        finally {
            memory.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int setIPv6(ByteBuffer memory, InetAddress address, int port) {
        int position = memory.position();
        memory.mark();
        try {
            memory.put(SOCKADDR_IN6_EMPTY_ARRAY);
            memory.putShort(position + Native.SOCKADDR_IN6_OFFSETOF_SIN6_FAMILY, Native.AF_INET6);
            memory.putShort(position + Native.SOCKADDR_IN6_OFFSETOF_SIN6_PORT, SockaddrIn.handleNetworkOrder(memory.order(), (short)port));
            byte[] bytes = address.getAddress();
            int offset = Native.SOCKADDR_IN6_OFFSETOF_SIN6_ADDR + Native.IN6_ADDRESS_OFFSETOF_S6_ADDR;
            if (bytes.length == 4) {
                memory.position(position + offset);
                memory.put(IPV4_MAPPED_IPV6_PREFIX);
                memory.put(bytes, 0, 4);
            } else {
                memory.position(position + offset);
                memory.put(bytes, 0, 16);
                memory.putInt(position + Native.SOCKADDR_IN6_OFFSETOF_SIN6_SCOPE_ID, ((Inet6Address)address).getScopeId());
            }
            int n = Native.SIZEOF_SOCKADDR_IN6;
            return n;
        }
        finally {
            memory.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static InetSocketAddress getIPv4(ByteBuffer memory, byte[] tmpArray) {
        assert (tmpArray.length == 4);
        int position = memory.position();
        memory.mark();
        try {
            int port = SockaddrIn.handleNetworkOrder(memory.order(), memory.getShort(position + Native.SOCKADDR_IN_OFFSETOF_SIN_PORT)) & 0xFFFF;
            memory.position(position + Native.SOCKADDR_IN_OFFSETOF_SIN_ADDR + Native.IN_ADDRESS_OFFSETOF_S_ADDR);
            memory.get(tmpArray);
            try {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(InetAddress.getByAddress(tmpArray), port);
                return inetSocketAddress;
            }
            catch (UnknownHostException ignore) {
                InetSocketAddress inetSocketAddress = null;
                memory.reset();
                return inetSocketAddress;
            }
        }
        finally {
            memory.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static InetSocketAddress getIPv6(ByteBuffer memory, byte[] ipv6Array, byte[] ipv4Array) {
        assert (ipv6Array.length == 16);
        assert (ipv4Array.length == 4);
        int position = memory.position();
        memory.mark();
        try {
            int port = SockaddrIn.handleNetworkOrder(memory.order(), memory.getShort(position + Native.SOCKADDR_IN6_OFFSETOF_SIN6_PORT)) & 0xFFFF;
            memory.position(position + Native.SOCKADDR_IN6_OFFSETOF_SIN6_ADDR + Native.IN6_ADDRESS_OFFSETOF_S6_ADDR);
            memory.get(ipv6Array);
            if (PlatformDependent.equals(ipv6Array, 0, IPV4_MAPPED_IPV6_PREFIX, 0, IPV4_MAPPED_IPV6_PREFIX.length)) {
                System.arraycopy(ipv6Array, IPV4_MAPPED_IPV6_PREFIX.length, ipv4Array, 0, 4);
                try {
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(Inet4Address.getByAddress(ipv4Array), port);
                    return inetSocketAddress;
                }
                catch (UnknownHostException ignore) {
                    InetSocketAddress inetSocketAddress = null;
                    memory.reset();
                    return inetSocketAddress;
                }
            }
            int scopeId = memory.getInt(position + Native.SOCKADDR_IN6_OFFSETOF_SIN6_SCOPE_ID);
            try {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(Inet6Address.getByAddress(null, ipv6Array, scopeId), port);
                return inetSocketAddress;
            }
            catch (UnknownHostException ignore) {
                InetSocketAddress inetSocketAddress = null;
                memory.reset();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                return inetSocketAddress;
            }
        }
        finally {
            memory.reset();
        }
    }

    static boolean hasPortIpv4(ByteBuffer memory) {
        int port = memory.getShort(memory.position() + Native.SOCKADDR_IN_OFFSETOF_SIN_PORT) & 0xFFFF;
        return port > 0;
    }

    static boolean hasPortIpv6(ByteBuffer memory) {
        int port = memory.getShort(memory.position() + Native.SOCKADDR_IN6_OFFSETOF_SIN6_PORT) & 0xFFFF;
        return port > 0;
    }

    private static short handleNetworkOrder(ByteOrder order, short v) {
        return order != ByteOrder.nativeOrder() ? v : Short.reverseBytes(v);
    }
}

