/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.netty.shaded.io.netty.channel.uring;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.dubbo.netty.shaded.io.netty.channel.Channel;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelOption;
import org.apache.dubbo.netty.shaded.io.netty.channel.socket.ServerSocketChannel;
import org.apache.dubbo.netty.shaded.io.netty.channel.socket.ServerSocketChannelConfig;
import org.apache.dubbo.netty.shaded.io.netty.channel.uring.AbstractIoUringServerChannel;
import org.apache.dubbo.netty.shaded.io.netty.channel.uring.IoUring;
import org.apache.dubbo.netty.shaded.io.netty.channel.uring.IoUringIoHandler;
import org.apache.dubbo.netty.shaded.io.netty.channel.uring.IoUringServerSocketChannelConfig;
import org.apache.dubbo.netty.shaded.io.netty.channel.uring.IoUringSocketChannel;
import org.apache.dubbo.netty.shaded.io.netty.channel.uring.LinuxSocket;
import org.apache.dubbo.netty.shaded.io.netty.channel.uring.SockaddrIn;

public final class IoUringServerSocketChannel
extends AbstractIoUringServerChannel
implements ServerSocketChannel {
    private final IoUringServerSocketChannelConfig config = new IoUringServerSocketChannelConfig(this);

    public IoUringServerSocketChannel() {
        super(LinuxSocket.newSocketStream(), false);
    }

    @Override
    public ServerSocketChannelConfig config() {
        return this.config;
    }

    @Override
    Channel newChildChannel(int fd, ByteBuffer acceptedAddressMemory) {
        IoUringIoHandler handler = (IoUringIoHandler)this.registration().attachment();
        LinuxSocket socket = new LinuxSocket(fd);
        if (acceptedAddressMemory != null) {
            InetSocketAddress address;
            if (socket.isIpv6()) {
                byte[] ipv6Array = handler.inet6AddressArray();
                byte[] ipv4Array = handler.inet4AddressArray();
                address = SockaddrIn.getIPv6(acceptedAddressMemory, ipv6Array, ipv4Array);
            } else {
                byte[] addressArray = handler.inet4AddressArray();
                address = SockaddrIn.getIPv4(acceptedAddressMemory, addressArray);
            }
            return new IoUringSocketChannel((Channel)this, new LinuxSocket(fd), address);
        }
        return new IoUringSocketChannel((Channel)this, new LinuxSocket(fd));
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public void doBind(SocketAddress localAddress) throws Exception {
        Integer fastOpen;
        super.doBind(localAddress);
        if (IoUring.isTcpFastOpenServerSideAvailable() && (fastOpen = this.config().getOption(ChannelOption.TCP_FASTOPEN)) != null && fastOpen > 0) {
            this.socket.setTcpFastOpen(fastOpen);
        }
        this.socket.listen(this.config.getBacklog());
        this.active = true;
    }
}

