/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.netty.shaded.io.netty.channel.uring;

import java.util.Objects;
import org.apache.dubbo.netty.shaded.io.netty.buffer.ByteBuf;
import org.apache.dubbo.netty.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.dubbo.netty.shaded.io.netty.channel.uring.IoUringBufferRingAllocator;
import org.apache.dubbo.netty.shaded.io.netty.util.internal.ObjectUtil;

public final class IoUringFixedBufferRingAllocator
implements IoUringBufferRingAllocator {
    private final ByteBufAllocator allocator;
    private final int bufferSize;

    public IoUringFixedBufferRingAllocator(ByteBufAllocator allocator, int bufferSize) {
        this.allocator = Objects.requireNonNull(allocator, "allocator");
        this.bufferSize = ObjectUtil.checkPositive(bufferSize, "bufferSize");
    }

    public IoUringFixedBufferRingAllocator(int bufferSize) {
        this(ByteBufAllocator.DEFAULT, bufferSize);
    }

    @Override
    public ByteBuf allocate() {
        return this.allocator.directBuffer(this.bufferSize);
    }

    @Override
    public void lastBytesRead(int attempted, int actual) {
    }
}

