/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.netty.shaded.io.netty.channel.uring;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.apache.dubbo.netty.shaded.io.netty.channel.DefaultFileRegion;
import org.apache.dubbo.netty.shaded.io.netty.channel.FileRegion;
import org.apache.dubbo.netty.shaded.io.netty.channel.unix.FileDescriptor;
import org.apache.dubbo.netty.shaded.io.netty.channel.uring.IoUringIoOps;
import org.apache.dubbo.netty.shaded.io.netty.channel.uring.Native;
import org.apache.dubbo.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import org.apache.dubbo.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

final class IoUringFileRegion
implements FileRegion {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(IoUringFileRegion.class);
    private static final short SPLICE_TO_PIPE = 1;
    private static final short SPLICE_TO_SOCKET = 2;
    final DefaultFileRegion fileRegion;
    private FileDescriptor[] pipe;
    private int transferred;
    private int pipeLen = -1;

    IoUringFileRegion(DefaultFileRegion fileRegion) {
        this.fileRegion = fileRegion;
    }

    void open() throws IOException {
        this.fileRegion.open();
        if (this.pipe == null) {
            this.pipe = FileDescriptor.pipe();
        }
    }

    IoUringIoOps splice(int fd) {
        if (this.pipeLen == -1) {
            return this.spliceToPipe();
        }
        return this.spliceToSocket(fd, this.pipeLen);
    }

    IoUringIoOps spliceToPipe() {
        int fileRegionFd = Native.getFd(this.fileRegion);
        int len = (int)(this.count() - this.transferred());
        int offset = (int)(this.position() + this.transferred());
        return IoUringIoOps.newSplice(fileRegionFd, offset, this.pipe[1].intValue(), -1L, len, 1, (short)1);
    }

    private IoUringIoOps spliceToSocket(int socket, int len) {
        return IoUringIoOps.newSplice(this.pipe[0].intValue(), -1L, socket, -1L, len, 1, (short)2);
    }

    int handleResult(int result, short data) {
        assert (result >= 0);
        if (data == 1) {
            this.transferred += result;
            this.pipeLen = result;
            return 0;
        }
        if (data == 2) {
            this.pipeLen -= result;
            assert (this.pipeLen >= 0);
            if (this.pipeLen == 0) {
                if (this.transferred() >= this.count()) {
                    return -1;
                }
                this.pipeLen = -1;
            }
            return result;
        }
        throw new IllegalArgumentException("Unknown data: " + data);
    }

    @Override
    public long position() {
        return this.fileRegion.position();
    }

    @Override
    public long transfered() {
        return this.transferred;
    }

    @Override
    public long transferred() {
        return this.transferred;
    }

    @Override
    public long count() {
        return this.fileRegion.count();
    }

    @Override
    public long transferTo(WritableByteChannel target, long position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileRegion retain() {
        this.fileRegion.retain();
        return this;
    }

    @Override
    public FileRegion retain(int increment) {
        this.fileRegion.retain(increment);
        return this;
    }

    @Override
    public FileRegion touch() {
        this.fileRegion.touch();
        return this;
    }

    @Override
    public FileRegion touch(Object hint) {
        this.fileRegion.touch(hint);
        return this;
    }

    @Override
    public int refCnt() {
        return this.fileRegion.refCnt();
    }

    @Override
    public boolean release() {
        if (this.fileRegion.release()) {
            this.closePipeIfNeeded();
            return true;
        }
        return false;
    }

    @Override
    public boolean release(int decrement) {
        if (this.fileRegion.release(decrement)) {
            this.closePipeIfNeeded();
            return true;
        }
        return false;
    }

    private void closePipeIfNeeded() {
        if (this.pipe != null) {
            IoUringFileRegion.closeSilently(this.pipe[0]);
            IoUringFileRegion.closeSilently(this.pipe[1]);
        }
    }

    private static void closeSilently(FileDescriptor fd) {
        try {
            fd.close();
        }
        catch (IOException e) {
            logger.debug("Error while closing a pipe", e);
        }
    }
}

