/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.netty.shaded.io.netty.channel.uring;

import java.util.Objects;
import org.apache.dubbo.netty.shaded.io.netty.channel.uring.IoUring;
import org.apache.dubbo.netty.shaded.io.netty.channel.uring.IoUringBufferRingAllocator;
import org.apache.dubbo.netty.shaded.io.netty.util.internal.ObjectUtil;

public final class IoUringBufferRingConfig {
    private final short bgId;
    private final short bufferRingSize;
    private final int batchSize;
    private final int maxUnreleasedBuffers;
    private final boolean incremental;
    private final IoUringBufferRingAllocator allocator;

    public IoUringBufferRingConfig(short bgId, short bufferRingSize, int maxUnreleasedBuffers, IoUringBufferRingAllocator allocator) {
        this(bgId, bufferRingSize, bufferRingSize / 2, maxUnreleasedBuffers, IoUring.isRegisterBufferRingIncSupported(), allocator);
    }

    public IoUringBufferRingConfig(short bgId, short bufferRingSize, int batchSize, int maxUnreleasedBuffers, boolean incremental, IoUringBufferRingAllocator allocator) {
        this.bgId = (short)ObjectUtil.checkPositiveOrZero(bgId, "bgId");
        this.bufferRingSize = IoUringBufferRingConfig.checkBufferRingSize(bufferRingSize);
        this.batchSize = ObjectUtil.checkInRange(batchSize, 1, bufferRingSize, "batchSize");
        this.maxUnreleasedBuffers = ObjectUtil.checkInRange(maxUnreleasedBuffers, bufferRingSize, Integer.MAX_VALUE, "maxUnreleasedBuffers");
        if (incremental && !IoUring.isRegisterBufferRingIncSupported()) {
            throw new IllegalArgumentException("Incremental buffer ring is not supported");
        }
        this.incremental = incremental;
        this.allocator = ObjectUtil.checkNotNull(allocator, "allocator");
    }

    public short bufferGroupId() {
        return this.bgId;
    }

    public short bufferRingSize() {
        return this.bufferRingSize;
    }

    public int batchSize() {
        return this.batchSize;
    }

    public int maxUnreleasedBuffers() {
        return this.maxUnreleasedBuffers;
    }

    public IoUringBufferRingAllocator allocator() {
        return this.allocator;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    private static short checkBufferRingSize(short bufferRingSize) {
        boolean isPowerOfTwo;
        if (bufferRingSize < 1) {
            throw new IllegalArgumentException("bufferRingSize: " + bufferRingSize + " (expected: > 0)");
        }
        boolean bl = isPowerOfTwo = (bufferRingSize & bufferRingSize - 1) == 0;
        if (!isPowerOfTwo) {
            throw new IllegalArgumentException("bufferRingSize: " + bufferRingSize + " (expected: power of 2)");
        }
        return bufferRingSize;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoUringBufferRingConfig that = (IoUringBufferRingConfig)o;
        return this.bgId == that.bgId;
    }

    public int hashCode() {
        return Objects.hashCode(this.bgId);
    }
}

