/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.netty.shaded.io.netty.channel.kqueue;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.dubbo.netty.shaded.io.netty.channel.Channel;
import org.apache.dubbo.netty.shaded.io.netty.channel.DefaultSelectStrategyFactory;
import org.apache.dubbo.netty.shaded.io.netty.channel.IoHandle;
import org.apache.dubbo.netty.shaded.io.netty.channel.IoHandler;
import org.apache.dubbo.netty.shaded.io.netty.channel.IoHandlerContext;
import org.apache.dubbo.netty.shaded.io.netty.channel.IoHandlerFactory;
import org.apache.dubbo.netty.shaded.io.netty.channel.IoOps;
import org.apache.dubbo.netty.shaded.io.netty.channel.IoRegistration;
import org.apache.dubbo.netty.shaded.io.netty.channel.SelectStrategy;
import org.apache.dubbo.netty.shaded.io.netty.channel.SelectStrategyFactory;
import org.apache.dubbo.netty.shaded.io.netty.channel.kqueue.AbstractKQueueChannel;
import org.apache.dubbo.netty.shaded.io.netty.channel.kqueue.KQueue;
import org.apache.dubbo.netty.shaded.io.netty.channel.kqueue.KQueueEventArray;
import org.apache.dubbo.netty.shaded.io.netty.channel.kqueue.KQueueIoEvent;
import org.apache.dubbo.netty.shaded.io.netty.channel.kqueue.KQueueIoHandle;
import org.apache.dubbo.netty.shaded.io.netty.channel.kqueue.KQueueIoOps;
import org.apache.dubbo.netty.shaded.io.netty.channel.kqueue.Native;
import org.apache.dubbo.netty.shaded.io.netty.channel.kqueue.NativeArrays;
import org.apache.dubbo.netty.shaded.io.netty.channel.unix.FileDescriptor;
import org.apache.dubbo.netty.shaded.io.netty.util.IntSupplier;
import org.apache.dubbo.netty.shaded.io.netty.util.collection.IntObjectHashMap;
import org.apache.dubbo.netty.shaded.io.netty.util.collection.IntObjectMap;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.ThreadAwareExecutor;
import org.apache.dubbo.netty.shaded.io.netty.util.internal.ObjectUtil;
import org.apache.dubbo.netty.shaded.io.netty.util.internal.StringUtil;
import org.apache.dubbo.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import org.apache.dubbo.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public final class KQueueIoHandler
implements IoHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(KQueueIoHandler.class);
    private static final AtomicIntegerFieldUpdater<KQueueIoHandler> WAKEN_UP_UPDATER = AtomicIntegerFieldUpdater.newUpdater(KQueueIoHandler.class, "wakenUp");
    private static final int KQUEUE_WAKE_UP_IDENT = 0;
    private static final int KQUEUE_MAX_TIMEOUT_SECONDS = 86399;
    private final boolean allowGrowing;
    private final FileDescriptor kqueueFd;
    private final KQueueEventArray changeList;
    private final KQueueEventArray eventList;
    private final SelectStrategy selectStrategy;
    private final NativeArrays nativeArrays;
    private final IntSupplier selectNowSupplier = new IntSupplier(){

        @Override
        public int get() throws Exception {
            return KQueueIoHandler.this.kqueueWaitNow();
        }
    };
    private final ThreadAwareExecutor executor;
    private final IntObjectMap<DefaultKqueueIoRegistration> registrations = new IntObjectHashMap<DefaultKqueueIoRegistration>(4096);
    private int numChannels;
    private volatile int wakenUp;

    public static IoHandlerFactory newFactory() {
        return KQueueIoHandler.newFactory(0, DefaultSelectStrategyFactory.INSTANCE);
    }

    public static IoHandlerFactory newFactory(int maxEvents, SelectStrategyFactory selectStrategyFactory) {
        ObjectUtil.checkPositiveOrZero(maxEvents, "maxEvents");
        ObjectUtil.checkNotNull(selectStrategyFactory, "selectStrategyFactory");
        return executor -> new KQueueIoHandler(executor, maxEvents, selectStrategyFactory.newSelectStrategy());
    }

    private KQueueIoHandler(ThreadAwareExecutor executor, int maxEvents, SelectStrategy strategy) {
        this.executor = ObjectUtil.checkNotNull(executor, "executor");
        this.selectStrategy = ObjectUtil.checkNotNull(strategy, "strategy");
        this.kqueueFd = Native.newKQueue();
        if (maxEvents == 0) {
            this.allowGrowing = true;
            maxEvents = 4096;
        } else {
            this.allowGrowing = false;
        }
        this.changeList = new KQueueEventArray(maxEvents);
        this.eventList = new KQueueEventArray(maxEvents);
        this.nativeArrays = new NativeArrays();
        int result = Native.keventAddUserEvent(this.kqueueFd.intValue(), 0);
        if (result < 0) {
            this.destroy();
            throw new IllegalStateException("kevent failed to add user event with errno: " + -result);
        }
    }

    @Override
    public void wakeup() {
        if (!this.executor.isExecutorThread(Thread.currentThread()) && WAKEN_UP_UPDATER.compareAndSet(this, 0, 1)) {
            this.wakeup0();
        }
    }

    private void wakeup0() {
        Native.keventTriggerUserEvent(this.kqueueFd.intValue(), 0);
    }

    private int kqueueWait(IoHandlerContext context, boolean oldWakeup) throws IOException {
        if (oldWakeup && !context.canBlock()) {
            return this.kqueueWaitNow();
        }
        long totalDelay = context.delayNanos(System.nanoTime());
        int delaySeconds = (int)Math.min(totalDelay / 1000000000L, 86399L);
        int delayNanos = (int)(totalDelay % 1000000000L);
        return this.kqueueWait(delaySeconds, delayNanos);
    }

    private int kqueueWaitNow() throws IOException {
        return this.kqueueWait(0, 0);
    }

    private int kqueueWait(int timeoutSec, int timeoutNs) throws IOException {
        int numEvents = Native.keventWait(this.kqueueFd.intValue(), this.changeList, this.eventList, timeoutSec, timeoutNs);
        this.changeList.clear();
        return numEvents;
    }

    private void processReady(int ready) {
        for (int i = 0; i < ready; ++i) {
            short filter = this.eventList.filter(i);
            short flags = this.eventList.flags(i);
            int ident = this.eventList.ident(i);
            if (filter == Native.EVFILT_USER || (flags & Native.EV_ERROR) != 0) {
                assert (filter != Native.EVFILT_USER || filter == Native.EVFILT_USER && ident == 0);
                continue;
            }
            DefaultKqueueIoRegistration registration = this.registrations.get(ident);
            if (registration == null) {
                logger.warn("events[{}]=[{}, {}] had no registration!", i, ident, filter);
                continue;
            }
            registration.handle(ident, filter, flags, this.eventList.fflags(i), this.eventList.data(i));
        }
    }

    @Override
    public int run(IoHandlerContext context) {
        int handled = 0;
        try {
            int strategy = this.selectStrategy.calculateStrategy(this.selectNowSupplier, !context.canBlock());
            switch (strategy) {
                case -2: {
                    return 0;
                }
                case -3: 
                case -1: {
                    strategy = this.kqueueWait(context, WAKEN_UP_UPDATER.getAndSet(this, 0) == 1);
                    if (this.wakenUp != 1) break;
                    this.wakeup0();
                }
            }
            if (strategy > 0) {
                handled = strategy;
                this.processReady(strategy);
            }
            if (this.allowGrowing && strategy == this.eventList.capacity()) {
                this.eventList.realloc(false);
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            KQueueIoHandler.handleLoopException(t);
        }
        return handled;
    }

    int numRegisteredChannels() {
        return this.numChannels;
    }

    List<Channel> registeredChannelsList() {
        IntObjectMap<DefaultKqueueIoRegistration> ch = this.registrations;
        if (ch.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Channel> channels = new ArrayList<Channel>(ch.size());
        for (DefaultKqueueIoRegistration registration : ch.values()) {
            if (!(registration.handle instanceof AbstractKQueueChannel.AbstractKQueueUnsafe)) continue;
            channels.add(((AbstractKQueueChannel.AbstractKQueueUnsafe)registration.handle).channel());
        }
        return Collections.unmodifiableList(channels);
    }

    private static void handleLoopException(Throwable t) {
        logger.warn("Unexpected exception in the selector loop.", t);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void prepareToDestroy() {
        DefaultKqueueIoRegistration[] copy;
        try {
            this.kqueueWaitNow();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (DefaultKqueueIoRegistration reg : copy = this.registrations.values().toArray(new DefaultKqueueIoRegistration[0])) {
            reg.close();
        }
    }

    @Override
    public void destroy() {
        try {
            try {
                this.kqueueFd.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close the kqueue fd.", e);
            }
        }
        finally {
            this.nativeArrays.free();
            this.changeList.free();
            this.eventList.free();
        }
    }

    @Override
    public IoRegistration register(IoHandle handle) {
        KQueueIoHandle kqueueHandle = KQueueIoHandler.cast(handle);
        if (kqueueHandle.ident() == 0) {
            throw new IllegalArgumentException("ident 0 is reserved for internal usage");
        }
        DefaultKqueueIoRegistration registration = new DefaultKqueueIoRegistration(this.executor, kqueueHandle);
        DefaultKqueueIoRegistration old = this.registrations.put(kqueueHandle.ident(), registration);
        if (old != null) {
            this.registrations.put(kqueueHandle.ident(), old);
            throw new IllegalStateException("registration for the KQueueIoHandle.ident() already exists");
        }
        if (kqueueHandle instanceof AbstractKQueueChannel.AbstractKQueueUnsafe) {
            ++this.numChannels;
        }
        return registration;
    }

    private static KQueueIoHandle cast(IoHandle handle) {
        if (handle instanceof KQueueIoHandle) {
            return (KQueueIoHandle)handle;
        }
        throw new IllegalArgumentException("IoHandle of type " + StringUtil.simpleClassName(handle) + " not supported");
    }

    private static KQueueIoOps cast(IoOps ops) {
        if (ops instanceof KQueueIoOps) {
            return (KQueueIoOps)ops;
        }
        throw new IllegalArgumentException("IoOps of type " + StringUtil.simpleClassName(ops) + " not supported");
    }

    @Override
    public boolean isCompatible(Class<? extends IoHandle> handleType) {
        return KQueueIoHandle.class.isAssignableFrom(handleType);
    }

    static {
        KQueue.ensureAvailability();
    }

    private final class DefaultKqueueIoRegistration
    implements IoRegistration {
        private final AtomicBoolean canceled = new AtomicBoolean();
        private final KQueueIoEvent event = new KQueueIoEvent();
        final KQueueIoHandle handle;
        private final ThreadAwareExecutor executor;

        DefaultKqueueIoRegistration(ThreadAwareExecutor executor, KQueueIoHandle handle) {
            this.executor = executor;
            this.handle = handle;
        }

        @Override
        public <T> T attachment() {
            return (T)KQueueIoHandler.this.nativeArrays;
        }

        @Override
        public long submit(IoOps ops) {
            KQueueIoOps kQueueIoOps = KQueueIoHandler.cast(ops);
            if (!this.isValid()) {
                return -1L;
            }
            short filter = kQueueIoOps.filter();
            short flags = kQueueIoOps.flags();
            int fflags = kQueueIoOps.fflags();
            if (this.executor.isExecutorThread(Thread.currentThread())) {
                this.evSet(filter, flags, fflags);
            } else {
                this.executor.execute(() -> this.evSet(filter, flags, fflags));
            }
            return 0L;
        }

        void handle(int ident, short filter, short flags, int fflags, long data) {
            this.event.update(ident, filter, flags, fflags, data);
            this.handle.handle(this, this.event);
        }

        private void evSet(short filter, short flags, int fflags) {
            KQueueIoHandler.this.changeList.evSet(this.handle.ident(), filter, flags, fflags);
        }

        @Override
        public boolean isValid() {
            return !this.canceled.get();
        }

        @Override
        public boolean cancel() {
            if (!this.canceled.compareAndSet(false, true)) {
                return false;
            }
            if (this.executor.isExecutorThread(Thread.currentThread())) {
                this.cancel0();
            } else {
                this.executor.execute(this::cancel0);
            }
            return true;
        }

        private void cancel0() {
            int ident = this.handle.ident();
            DefaultKqueueIoRegistration old = (DefaultKqueueIoRegistration)KQueueIoHandler.this.registrations.remove(ident);
            if (old != null) {
                if (old != this) {
                    KQueueIoHandler.this.registrations.put(ident, old);
                } else if (old.handle instanceof AbstractKQueueChannel.AbstractKQueueUnsafe) {
                    KQueueIoHandler.this.numChannels--;
                }
            }
        }

        void close() {
            this.cancel();
            try {
                this.handle.close();
            }
            catch (Exception e) {
                logger.debug("Exception during closing " + this.handle, e);
            }
        }
    }
}

