/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.netty.shaded.io.netty.channel.embedded;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.dubbo.netty.shaded.io.netty.channel.Channel;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelFuture;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelPromise;
import org.apache.dubbo.netty.shaded.io.netty.channel.DefaultChannelPromise;
import org.apache.dubbo.netty.shaded.io.netty.channel.EventLoop;
import org.apache.dubbo.netty.shaded.io.netty.channel.EventLoopGroup;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.AbstractScheduledEventExecutor;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.Future;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.MockTicker;
import org.apache.dubbo.netty.shaded.io.netty.util.concurrent.Ticker;
import org.apache.dubbo.netty.shaded.io.netty.util.internal.ObjectUtil;

final class EmbeddedEventLoop
extends AbstractScheduledEventExecutor
implements EventLoop {
    private final FreezableTicker ticker = new FreezableTicker();
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>(2);

    EmbeddedEventLoop() {
    }

    @Override
    public EventLoopGroup parent() {
        return (EventLoopGroup)super.parent();
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    public void execute(Runnable command) {
        this.tasks.add(ObjectUtil.checkNotNull(command, "command"));
    }

    void runTasks() {
        Runnable task;
        while ((task = this.tasks.poll()) != null) {
            task.run();
        }
    }

    boolean hasPendingNormalTasks() {
        return !this.tasks.isEmpty();
    }

    long runScheduledTasks() {
        long time = this.getCurrentTimeNanos();
        Runnable task;
        while ((task = this.pollScheduledTask(time)) != null) {
            task.run();
        }
        return this.nextScheduledTaskNano();
    }

    long nextScheduledTask() {
        return this.nextScheduledTaskNano();
    }

    @Override
    public Ticker ticker() {
        return this.ticker;
    }

    @Override
    protected long getCurrentTimeNanos() {
        return this.ticker.nanoTime();
    }

    void advanceTimeBy(long nanos) {
        this.ticker.advance(nanos, TimeUnit.NANOSECONDS);
    }

    void freezeTime() {
        this.ticker.freezeTime();
    }

    void unfreezeTime() {
        this.ticker.unfreezeTime();
    }

    @Override
    protected void cancelScheduledTasks() {
        super.cancelScheduledTasks();
    }

    @Override
    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<?> terminationFuture() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShuttingDown() {
        return false;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        return false;
    }

    @Override
    public ChannelFuture register(Channel channel) {
        return this.register(new DefaultChannelPromise(channel, this));
    }

    @Override
    public ChannelFuture register(ChannelPromise promise) {
        ObjectUtil.checkNotNull(promise, "promise");
        promise.channel().unsafe().register(this, promise);
        return promise;
    }

    @Override
    @Deprecated
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        channel.unsafe().register(this, promise);
        return promise;
    }

    @Override
    public boolean inEventLoop() {
        return true;
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return true;
    }

    private static final class FreezableTicker
    implements MockTicker {
        private final Ticker unfrozen = Ticker.systemTicker();
        private final Lock lock = new ReentrantLock();
        private final Condition cond = this.lock.newCondition();
        private long startTime;
        private long frozenTimestamp;
        private boolean timeFrozen;

        private FreezableTicker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void advance(long amount, TimeUnit unit) {
            this.lock.lock();
            try {
                long nanos = unit.toNanos(amount);
                if (this.timeFrozen) {
                    this.frozenTimestamp += nanos;
                } else {
                    this.startTime -= nanos;
                }
                this.cond.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public long nanoTime() {
            this.lock.lock();
            try {
                if (this.timeFrozen) {
                    long l = this.frozenTimestamp;
                    return l;
                }
                long l = this.unfrozen.nanoTime() - this.startTime;
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sleep(long delay, TimeUnit unit) throws InterruptedException {
            long deadline = this.nanoTime() + unit.toNanos(delay);
            this.lock.lockInterruptibly();
            try {
                long timeout;
                while ((timeout = deadline - this.nanoTime()) >= 0L) {
                    if (this.timeFrozen) {
                        this.cond.await();
                        continue;
                    }
                    this.cond.awaitNanos(timeout);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public void freezeTime() {
            this.lock.lock();
            try {
                if (!this.timeFrozen) {
                    this.frozenTimestamp = this.nanoTime();
                    this.timeFrozen = true;
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public void unfreezeTime() {
            this.lock.lock();
            try {
                if (this.timeFrozen) {
                    this.startTime = this.unfrozen.nanoTime() - this.frozenTimestamp;
                    this.timeFrozen = false;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

