/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.netty.shaded.io.netty.channel;

import java.util.Map;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandler;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.dubbo.netty.shaded.io.netty.channel.ChannelHandlerMask;
import org.apache.dubbo.netty.shaded.io.netty.util.internal.InternalThreadLocalMap;

public abstract class ChannelHandlerAdapter
implements ChannelHandler {
    boolean added;

    protected void ensureNotSharable() {
        if (this.isSharable()) {
            throw new IllegalStateException("ChannelHandler " + this.getClass().getName() + " is not allowed to be shared");
        }
    }

    public boolean isSharable() {
        Class<?> clazz = this.getClass();
        Map<Class<?>, Boolean> cache = InternalThreadLocalMap.get().handlerSharableCache();
        Boolean sharable = cache.get(clazz);
        if (sharable == null) {
            sharable = clazz.isAnnotationPresent(ChannelHandler.Sharable.class);
            cache.put(clazz, sharable);
        }
        return sharable;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    @ChannelHandlerMask.Skip
    @Deprecated
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.fireExceptionCaught(cause);
    }
}

