/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.registry.collector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.metrics.collector.CombMetricsCollector;
import org.apache.dubbo.metrics.data.ApplicationStatComposite;
import org.apache.dubbo.metrics.data.BaseStatComposite;
import org.apache.dubbo.metrics.data.RtStatComposite;
import org.apache.dubbo.metrics.data.ServiceStatComposite;
import org.apache.dubbo.metrics.model.ApplicationMetric;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.ServiceKeyMetric;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsKeyWrapper;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.metrics.registry.RegistryMetricsConstants;
import org.apache.dubbo.metrics.registry.collector.RegistryStatComposite;
import org.apache.dubbo.metrics.registry.event.RegistryEvent;
import org.apache.dubbo.metrics.registry.event.RegistrySubDispatcher;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Activate
public class RegistryMetricsCollector
extends CombMetricsCollector<RegistryEvent> {
    private Boolean collectEnabled = null;
    private final ApplicationModel applicationModel;
    private final RegistryStatComposite internalStat;

    public RegistryMetricsCollector(ApplicationModel applicationModel) {
        super(new BaseStatComposite(applicationModel){

            @Override
            protected void init(ApplicationStatComposite applicationStatComposite) {
                super.init(applicationStatComposite);
                applicationStatComposite.init(RegistryMetricsConstants.APP_LEVEL_KEYS);
            }

            @Override
            protected void init(ServiceStatComposite serviceStatComposite) {
                super.init(serviceStatComposite);
                serviceStatComposite.initWrapper(RegistryMetricsConstants.SERVICE_LEVEL_KEYS);
            }

            @Override
            protected void init(RtStatComposite rtStatComposite) {
                super.init(rtStatComposite);
                rtStatComposite.init(RegistryMetricsConstants.OP_TYPE_REGISTER, RegistryMetricsConstants.OP_TYPE_SUBSCRIBE, RegistryMetricsConstants.OP_TYPE_NOTIFY, RegistryMetricsConstants.OP_TYPE_REGISTER_SERVICE, RegistryMetricsConstants.OP_TYPE_SUBSCRIBE_SERVICE);
            }
        });
        super.setEventMulticaster(new RegistrySubDispatcher(this));
        this.internalStat = new RegistryStatComposite(applicationModel);
        this.applicationModel = applicationModel;
    }

    public void setCollectEnabled(Boolean collectEnabled) {
        if (collectEnabled != null) {
            this.collectEnabled = collectEnabled;
        }
    }

    @Override
    public boolean isCollectEnabled() {
        if (this.collectEnabled == null) {
            ConfigManager configManager = this.applicationModel.getApplicationConfigManager();
            configManager.getMetrics().ifPresent(metricsConfig -> this.setCollectEnabled(metricsConfig.getEnableRegistry()));
        }
        return Optional.ofNullable(this.collectEnabled).orElse(false);
    }

    @Override
    public List<MetricSample> collect() {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        if (!this.isCollectEnabled()) {
            return list;
        }
        list.addAll(super.export(MetricsCategory.REGISTRY));
        list.addAll(this.internalStat.export(MetricsCategory.REGISTRY));
        return list;
    }

    public void incrMetricsNum(MetricsKey metricsKey, List<String> registryClusterNames) {
        registryClusterNames.forEach(name -> this.internalStat.incrMetricsNum(metricsKey, (String)name));
    }

    public void incrRegisterFinishNum(MetricsKey metricsKey, String registryOpType, List<String> registryClusterNames, Long responseTime) {
        registryClusterNames.forEach(name -> {
            ApplicationMetric applicationMetric = new ApplicationMetric(this.applicationModel);
            applicationMetric.setExtraInfo(Collections.singletonMap("REGISTRY_CLUSTER".toLowerCase(), name));
            this.internalStat.incrMetricsNum(metricsKey, (String)name);
            this.getStats().getRtStatComposite().calcServiceKeyRt(registryOpType, responseTime, applicationMetric);
        });
    }

    public void incrServiceRegisterNum(MetricsKeyWrapper wrapper, String serviceKey, List<String> registryClusterNames, int size) {
        registryClusterNames.forEach(name -> this.stats.incrementServiceKey(wrapper, serviceKey, Collections.singletonMap("REGISTRY_CLUSTER".toLowerCase(), name), size));
    }

    public void incrServiceRegisterFinishNum(MetricsKeyWrapper wrapper, String serviceKey, List<String> registryClusterNames, int size, Long responseTime) {
        registryClusterNames.forEach(name -> {
            Map<String, String> extraInfo = Collections.singletonMap("REGISTRY_CLUSTER".toLowerCase(), name);
            ServiceKeyMetric serviceKeyMetric = new ServiceKeyMetric(this.applicationModel, serviceKey);
            serviceKeyMetric.setExtraInfo(extraInfo);
            this.stats.incrementServiceKey(wrapper, serviceKey, extraInfo, size);
            this.getStats().getRtStatComposite().calcServiceKeyRt(wrapper.getType(), responseTime, serviceKeyMetric);
        });
    }

    public void setNum(MetricsKeyWrapper metricsKey, String serviceKey, int num, Map<String, String> attachments) {
        this.stats.setServiceKey(metricsKey, serviceKey, num, attachments);
    }

    @Override
    public boolean calSamplesChanged() {
        boolean changed = this.stats.calSamplesChanged();
        changed = this.internalStat.calSamplesChanged() || changed;
        return changed;
    }
}

