/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.metrics.model.MetricsSupport;
import org.apache.dubbo.metrics.model.ServiceKeyMetric;
import org.apache.dubbo.metrics.model.key.MetricsLevel;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.support.RpcUtils;

public class MethodMetric
extends ServiceKeyMetric {
    private String side;
    private final String methodName;
    private String group;
    private String version;
    private volatile int hashCode = 0;

    public MethodMetric(ApplicationModel applicationModel, Invocation invocation, boolean serviceLevel) {
        super(applicationModel, MetricsSupport.getInterfaceName(invocation));
        this.side = MetricsSupport.getSide(invocation);
        this.group = MetricsSupport.getGroup(invocation);
        this.version = MetricsSupport.getVersion(invocation);
        this.methodName = serviceLevel ? null : RpcUtils.getMethodName(invocation);
    }

    public static boolean isServiceLevel(ApplicationModel applicationModel) {
        if (applicationModel == null) {
            return false;
        }
        ConfigManager applicationConfigManager = applicationModel.getApplicationConfigManager();
        if (applicationConfigManager == null) {
            return false;
        }
        Optional<MetricsConfig> metrics = applicationConfigManager.getMetrics();
        if (!metrics.isPresent()) {
            return false;
        }
        String rpcLevel = metrics.map(MetricsConfig::getRpcLevel).orElse(MetricsLevel.METHOD.name());
        rpcLevel = StringUtils.isBlank(rpcLevel) ? MetricsLevel.METHOD.name() : rpcLevel;
        return MetricsLevel.SERVICE.name().equalsIgnoreCase(rpcLevel);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public Map<String, String> getTags() {
        Map<String, String> tags = MetricsSupport.methodTags(this.getApplicationModel(), this.getServiceKey(), this.methodName);
        tags.put("group", this.group);
        tags.put("version", this.version);
        return tags;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getSide() {
        return this.side;
    }

    public void setSide(String side) {
        this.side = side;
    }

    @Override
    public String toString() {
        return "MethodMetric{applicationName='" + this.getApplicationName() + '\'' + ", side='" + this.side + '\'' + ", interfaceName='" + this.getServiceKey() + '\'' + ", methodName='" + this.methodName + '\'' + ", group='" + this.group + '\'' + ", version='" + this.version + '\'' + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodMetric that = (MethodMetric)o;
        return Objects.equals(this.getApplicationModel(), that.getApplicationModel()) && Objects.equals(this.side, that.side) && Objects.equals(this.getServiceKey(), that.getServiceKey()) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.group, that.group) && Objects.equals(this.version, that.version);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.getApplicationModel(), this.side, this.getServiceKey(), this.methodName, this.group, this.version);
        }
        return this.hashCode;
    }
}

