/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector.sample;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.store.DataStore;
import org.apache.dubbo.common.store.DataStoreUpdateListener;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.threadpool.support.AbortPolicyWithReport;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.collector.sample.MetricThreadPoolExhaustedListener;
import org.apache.dubbo.metrics.collector.sample.MetricsSampler;
import org.apache.dubbo.metrics.collector.sample.ThreadRejectMetricsCountSampler;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.ThreadPoolMetric;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ThreadPoolMetricsSampler
implements MetricsSampler,
DataStoreUpdateListener {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ThreadPoolMetricsSampler.class);
    private final DefaultMetricsCollector collector;
    private FrameworkExecutorRepository frameworkExecutorRepository;
    private DataStore dataStore;
    private final Map<String, ThreadPoolExecutor> sampleThreadPoolExecutor = new ConcurrentHashMap<String, ThreadPoolExecutor>();
    private final ConcurrentHashMap<String, ThreadPoolMetric> threadPoolMetricMap = new ConcurrentHashMap();
    private final AtomicBoolean samplesChanged = new AtomicBoolean(true);

    public ThreadPoolMetricsSampler(DefaultMetricsCollector collector) {
        this.collector = collector;
    }

    @Override
    public void onUpdate(String componentName, String key, Object value) {
        if (CommonConstants.EXECUTOR_SERVICE_COMPONENT_KEY.equals(componentName)) {
            if (value instanceof ThreadPoolExecutor) {
                this.addExecutors("DubboServerHandler-" + key, (ThreadPoolExecutor)value);
            }
        } else if ("CONSUMER_SHARED_SERVICE_EXECUTOR".equals(componentName) && value instanceof ThreadPoolExecutor) {
            this.addExecutors("DubboClientHandler-" + key, (ThreadPoolExecutor)value);
        }
    }

    public void addExecutors(String name, ExecutorService executorService) {
        Optional.ofNullable(executorService).filter(Objects::nonNull).filter(e -> e instanceof ThreadPoolExecutor).map(e -> (ThreadPoolExecutor)e).ifPresent(threadPoolExecutor -> {
            if (this.sampleThreadPoolExecutor.put(name, (ThreadPoolExecutor)threadPoolExecutor) == null) {
                this.samplesChanged.set(true);
            }
        });
    }

    @Override
    public List<MetricSample> sample() {
        ArrayList<MetricSample> metricSamples = new ArrayList<MetricSample>();
        this.sampleThreadPoolExecutor.forEach((name, executor) -> metricSamples.addAll(this.createMetricsSample((String)name, (ThreadPoolExecutor)executor)));
        return metricSamples;
    }

    private List<MetricSample> createMetricsSample(String name, ThreadPoolExecutor executor) {
        ArrayList<MetricSample> list = new ArrayList<MetricSample>();
        ThreadPoolMetric threadPoolMetric = ConcurrentHashMapUtils.computeIfAbsent(this.threadPoolMetricMap, name, v -> new ThreadPoolMetric(this.collector.getApplicationName(), name, executor));
        list.add(new GaugeMetricSample<ThreadPoolMetric>(MetricsKey.THREAD_POOL_CORE_SIZE, threadPoolMetric.getTags(), MetricsCategory.THREAD_POOL, threadPoolMetric, ThreadPoolMetric::getCorePoolSize));
        list.add(new GaugeMetricSample<ThreadPoolMetric>(MetricsKey.THREAD_POOL_LARGEST_SIZE, threadPoolMetric.getTags(), MetricsCategory.THREAD_POOL, threadPoolMetric, ThreadPoolMetric::getLargestPoolSize));
        list.add(new GaugeMetricSample<ThreadPoolMetric>(MetricsKey.THREAD_POOL_MAX_SIZE, threadPoolMetric.getTags(), MetricsCategory.THREAD_POOL, threadPoolMetric, ThreadPoolMetric::getMaximumPoolSize));
        list.add(new GaugeMetricSample<ThreadPoolMetric>(MetricsKey.THREAD_POOL_ACTIVE_SIZE, threadPoolMetric.getTags(), MetricsCategory.THREAD_POOL, threadPoolMetric, ThreadPoolMetric::getActiveCount));
        list.add(new GaugeMetricSample<ThreadPoolMetric>(MetricsKey.THREAD_POOL_THREAD_COUNT, threadPoolMetric.getTags(), MetricsCategory.THREAD_POOL, threadPoolMetric, ThreadPoolMetric::getPoolSize));
        list.add(new GaugeMetricSample<ThreadPoolMetric>(MetricsKey.THREAD_POOL_QUEUE_SIZE, threadPoolMetric.getTags(), MetricsCategory.THREAD_POOL, threadPoolMetric, ThreadPoolMetric::getQueueSize));
        return list;
    }

    public void registryDefaultSampleThreadPoolExecutor() {
        ApplicationModel applicationModel = this.collector.getApplicationModel();
        if (applicationModel == null) {
            return;
        }
        this.addRpcExecutors();
        this.addFrameworkExecutors();
        this.addExecutorRejectMetrics();
    }

    private void addExecutorRejectMetrics() {
        ThreadRejectMetricsCountSampler threadRejectMetricsCountSampler = new ThreadRejectMetricsCountSampler(this.collector);
        this.sampleThreadPoolExecutor.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("DubboServerHandler")).forEach(entry -> {
            if (((ThreadPoolExecutor)entry.getValue()).getRejectedExecutionHandler() instanceof AbortPolicyWithReport) {
                MetricThreadPoolExhaustedListener metricThreadPoolExhaustedListener = new MetricThreadPoolExhaustedListener((String)entry.getKey(), threadRejectMetricsCountSampler);
                ((AbortPolicyWithReport)((ThreadPoolExecutor)entry.getValue()).getRejectedExecutionHandler()).addThreadPoolExhaustedEventListener(metricThreadPoolExhaustedListener);
            }
        });
    }

    private void addRpcExecutors() {
        if (this.dataStore == null) {
            this.dataStore = this.collector.getApplicationModel().getExtensionLoader(DataStore.class).getDefaultExtension();
        }
        if (this.dataStore != null) {
            ExecutorService executor;
            this.dataStore.addListener(this);
            Map<String, Object> executors = this.dataStore.get(CommonConstants.EXECUTOR_SERVICE_COMPONENT_KEY);
            for (Map.Entry<String, Object> entry : executors.entrySet()) {
                executor = (ExecutorService)entry.getValue();
                if (!(executor instanceof ThreadPoolExecutor)) continue;
                this.addExecutors("DubboServerHandler-" + entry.getKey(), executor);
            }
            executors = this.dataStore.get("CONSUMER_SHARED_SERVICE_EXECUTOR");
            for (Map.Entry<String, Object> entry : executors.entrySet()) {
                executor = (ExecutorService)entry.getValue();
                if (!(executor instanceof ThreadPoolExecutor)) continue;
                this.addExecutors("DubboClientHandler-" + entry.getKey(), executor);
            }
        }
    }

    private void addFrameworkExecutors() {
        try {
            if (this.frameworkExecutorRepository == null) {
                this.frameworkExecutorRepository = this.collector.getApplicationModel().getBeanFactory().getBean(FrameworkExecutorRepository.class);
            }
        }
        catch (Exception ex) {
            this.logger.warn("0-13", "", "", "ThreadPoolMetricsSampler! frameworkExecutorRepository non-init");
        }
        if (this.frameworkExecutorRepository == null) {
            return;
        }
        this.addExecutors("poolRouterExecutor", this.frameworkExecutorRepository.getPoolRouterExecutor());
        this.addExecutors("metadataRetryExecutor", this.frameworkExecutorRepository.getMetadataRetryExecutor());
        this.addExecutors("internalServiceExecutor", this.frameworkExecutorRepository.getInternalServiceExecutor());
        this.addExecutors("connectivityScheduledExecutor", this.frameworkExecutorRepository.getConnectivityScheduledExecutor());
        this.addExecutors("cacheRefreshingScheduledExecutor", this.frameworkExecutorRepository.getCacheRefreshingScheduledExecutor());
        this.addExecutors("sharedExecutor", this.frameworkExecutorRepository.getSharedExecutor());
        this.addExecutors("sharedScheduledExecutor", this.frameworkExecutorRepository.getSharedScheduledExecutor());
        this.addExecutors("mappingRefreshingExecutor", this.frameworkExecutorRepository.getMappingRefreshingExecutor());
    }

    @Override
    public boolean calSamplesChanged() {
        return this.samplesChanged.compareAndSet(true, false);
    }
}

