/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.JRE;
import org.apache.dubbo.common.utils.StringUtils;

public class CollectionUtils {
    private static final Comparator<String> SIMPLE_NAME_COMPARATOR = (s1, s2) -> {
        int i2;
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        int i1 = s1.lastIndexOf(46);
        if (i1 >= 0) {
            s1 = s1.substring(i1 + 1);
        }
        if ((i2 = s2.lastIndexOf(46)) >= 0) {
            s2 = s2.substring(i2 + 1);
        }
        return s1.compareToIgnoreCase((String)s2);
    };

    private CollectionUtils() {
    }

    public static <T> List<T> sort(List<T> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Collections.sort(list);
        }
        return list;
    }

    public static List<String> sortSimpleName(List<String> list) {
        if (list != null && list.size() > 0) {
            Collections.sort(list, SIMPLE_NAME_COMPARATOR);
        }
        return list;
    }

    public static <K, V> Map<V, K> flip(Map<K, V> map) {
        if (CollectionUtils.isEmptyMap(map)) {
            return map;
        }
        HashSet<V> set = new HashSet<V>(map.values());
        if (set.size() != map.size()) {
            throw new IllegalArgumentException("The map value must be unique.");
        }
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public static Map<String, Map<String, String>> splitAll(Map<String, List<String>> list, String separator) {
        if (list == null) {
            return null;
        }
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, List<String>> entry : list.entrySet()) {
            result.put(entry.getKey(), CollectionUtils.split(entry.getValue(), separator));
        }
        return result;
    }

    public static Map<String, List<String>> joinAll(Map<String, Map<String, String>> map, String separator) {
        if (map == null) {
            return null;
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
            result.put(entry.getKey(), CollectionUtils.join(entry.getValue(), separator));
        }
        return result;
    }

    public static Map<String, String> split(List<String> list, String separator) {
        if (list == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (list.isEmpty()) {
            return map;
        }
        for (String item : list) {
            int index = item.indexOf(separator);
            if (index == -1) {
                map.put(item, "");
                continue;
            }
            map.put(item.substring(0, index), item.substring(index + 1));
        }
        return map;
    }

    public static List<String> join(Map<String, String> map, String separator) {
        if (map == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (map.size() == 0) {
            return list;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isEmpty(value)) {
                list.add(key);
                continue;
            }
            list.add(key + separator + value);
        }
        return list;
    }

    public static String join(List<String> list, String separator) {
        StringBuilder sb = new StringBuilder();
        for (String ele : list) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(ele);
        }
        return sb.toString();
    }

    public static boolean mapEquals(Map<?, ?> map1, Map<?, ?> map2) {
        if (map1 == null && map2 == null) {
            return true;
        }
        if (map1 == null || map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<?, ?> entry : map1.entrySet()) {
            Object value2;
            Object key = entry.getKey();
            Object value1 = entry.getValue();
            if (CollectionUtils.objectEquals(value1, value2 = map2.get(key))) continue;
            return false;
        }
        return true;
    }

    private static boolean objectEquals(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static Map<String, String> toStringMap(String ... pairs) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (ArrayUtils.isEmpty(pairs)) {
            return parameters;
        }
        if (pairs.length > 0) {
            if (pairs.length % 2 != 0) {
                throw new IllegalArgumentException("pairs must be even.");
            }
            for (int i = 0; i < pairs.length; i += 2) {
                parameters.put(pairs[i], pairs[i + 1]);
            }
        }
        return parameters;
    }

    public static <K, V> Map<K, V> toMap(Object ... pairs) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        if (pairs == null || pairs.length == 0) {
            return ret;
        }
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException("Map pairs can not be odd number.");
        }
        int len = pairs.length / 2;
        for (int i = 0; i < len; ++i) {
            ret.put(pairs[2 * i], pairs[2 * i + 1]);
        }
        return ret;
    }

    public static <K, V> Map<K, V> objToMap(Object object) throws IllegalAccessException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (object != null) {
            Field[] fields;
            for (Field field : fields = object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object value = field.get(object);
                if (value == null) continue;
                ret.put(field.getName(), value);
            }
        }
        return ret;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static boolean isEmptyMap(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmptyMap(Map map) {
        return !CollectionUtils.isEmptyMap(map);
    }

    public static <T> Set<T> ofSet(T ... values) {
        int size;
        int n = size = values == null ? 0 : values.length;
        if (size < 1) {
            return Collections.emptySet();
        }
        float loadFactor = 1.0f / ((float)(size + 1) * 1.0f);
        if (loadFactor > 0.75f) {
            loadFactor = 0.75f;
        }
        LinkedHashSet<T> elements = new LinkedHashSet<T>(size, loadFactor);
        for (int i = 0; i < size; ++i) {
            elements.add(values[i]);
        }
        return Collections.unmodifiableSet(elements);
    }

    public static int size(Collection<?> collection) {
        return collection == null ? 0 : collection.size();
    }

    public static boolean equals(Collection<?> one, Collection<?> another) {
        if (one == another) {
            return true;
        }
        if (CollectionUtils.isEmpty(one) && CollectionUtils.isEmpty(another)) {
            return true;
        }
        if (CollectionUtils.size(one) != CollectionUtils.size(another)) {
            return false;
        }
        try {
            return one.containsAll(another);
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
    }

    public static <T> int addAll(Collection<T> collection, T ... values) {
        int size;
        int n = size = values == null ? 0 : values.length;
        if (collection == null || size < 1) {
            return 0;
        }
        int effectedCount = 0;
        for (int i = 0; i < size; ++i) {
            if (!collection.add(values[i])) continue;
            ++effectedCount;
        }
        return effectedCount;
    }

    public static <T> T first(Collection<T> values) {
        if (CollectionUtils.isEmpty(values)) {
            return null;
        }
        if (values instanceof List) {
            return (T)((List)values).get(0);
        }
        return values.iterator().next();
    }

    public static <T> T first(List<T> values) {
        if (CollectionUtils.isEmpty(values)) {
            return null;
        }
        return values.get(0);
    }

    public static <T> Set<T> toTreeSet(Set<T> set) {
        if (CollectionUtils.isEmpty(set)) {
            return set;
        }
        if (!(set instanceof TreeSet)) {
            set = new TreeSet<T>(set);
        }
        return set;
    }

    public static <T> Set<T> newHashSet(int expectedSize) {
        return new HashSet(CollectionUtils.capacity(expectedSize));
    }

    public static <T> Set<T> newLinkedHashSet(int expectedSize) {
        return new LinkedHashSet(CollectionUtils.capacity(expectedSize));
    }

    public static <K, T> Map<K, T> newHashMap(int expectedSize) {
        return new HashMap(CollectionUtils.capacity(expectedSize));
    }

    public static <K, T> Map<K, T> newLinkedHashMap(int expectedSize) {
        return new LinkedHashMap(CollectionUtils.capacity(expectedSize));
    }

    public static <K, T> Map<K, T> newConcurrentHashMap(int expectedSize) {
        if (JRE.JAVA_8.isCurrentVersion()) {
            return new SafeConcurrentHashMap(CollectionUtils.capacity(expectedSize));
        }
        return new ConcurrentHashMap(CollectionUtils.capacity(expectedSize));
    }

    public static <K, T> Map<K, T> newConcurrentHashMap() {
        if (JRE.JAVA_8.isCurrentVersion()) {
            return new SafeConcurrentHashMap();
        }
        return new ConcurrentHashMap();
    }

    public static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            if (expectedSize < 0) {
                throw new IllegalArgumentException("expectedSize cannot be negative but was: " + expectedSize);
            }
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return (int)((float)expectedSize / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }

    public static class SafeConcurrentHashMap<K, V>
    extends ConcurrentHashMap<K, V> {
        private static final long serialVersionUID = 1L;

        public SafeConcurrentHashMap() {
        }

        public SafeConcurrentHashMap(int initialCapacity) {
            super(initialCapacity);
        }

        public SafeConcurrentHashMap(Map<? extends K, ? extends V> m) {
            super(m);
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            Object value = this.get(key);
            if (value != null) {
                return value;
            }
            value = mappingFunction.apply(key);
            if (value == null) {
                return null;
            }
            Object exists = this.putIfAbsent(key, value);
            if (exists != null) {
                return exists;
            }
            return value;
        }
    }
}

