/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.convert.multiple;

import org.apache.dubbo.common.extension.ExtensionScope;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.common.lang.Prioritized;
import org.apache.dubbo.common.utils.TypeUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;

@SPI(scope=ExtensionScope.FRAMEWORK)
public interface MultiValueConverter<S>
extends Prioritized {
    public boolean accept(Class<S> var1, Class<?> var2);

    public Object convert(S var1, Class<?> var2, Class<?> var3);

    default public Class<S> getSourceType() {
        return TypeUtils.findActualTypeArgument(this.getClass(), MultiValueConverter.class, 0);
    }

    @Deprecated
    public static MultiValueConverter<?> find(Class<?> sourceType, Class<?> targetType) {
        return FrameworkModel.defaultModel().getExtensionLoader(MultiValueConverter.class).getSupportedExtensionInstances().stream().filter(converter -> converter.accept(sourceType, targetType)).findFirst().orElse(null);
    }

    @Deprecated
    public static <T> T convertIfPossible(Object source, Class<?> multiValueType, Class<?> elementType) {
        Class<?> sourceType = source.getClass();
        MultiValueConverter<?> converter = MultiValueConverter.find(sourceType, multiValueType);
        if (converter != null) {
            return (T)converter.convert(source, multiValueType, elementType);
        }
        return null;
    }
}

