/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common;

import java.util.Objects;
import org.apache.dubbo.common.BaseServiceMetadata;
import org.apache.dubbo.common.utils.StringUtils;

public class ServiceKey {
    private final String interfaceName;
    private final String group;
    private final String version;

    public ServiceKey(String interfaceName, String version, String group) {
        this.interfaceName = interfaceName;
        this.group = group;
        this.version = version;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getGroup() {
        return this.group;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceKey that = (ServiceKey)o;
        return Objects.equals(this.interfaceName, that.interfaceName) && Objects.equals(this.group, that.group) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.interfaceName, this.group, this.version);
    }

    public String toString() {
        return BaseServiceMetadata.buildServiceKey(this.interfaceName, this.group, this.version);
    }

    public static class Matcher {
        public static boolean isMatch(ServiceKey rule, ServiceKey target) {
            boolean match;
            if (!Objects.equals(rule.getInterfaceName(), target.getInterfaceName())) {
                return false;
            }
            if (!"*".equals(rule.getVersion())) {
                if (StringUtils.isEmpty(rule.getVersion()) && !StringUtils.isEmpty(target.getVersion())) {
                    return false;
                }
                if (!StringUtils.isEmpty(rule.getVersion())) {
                    if (rule.getVersion().contains(",")) {
                        String[] versions = rule.getVersion().split("\\,", -1);
                        match = false;
                        for (String version : versions) {
                            if (StringUtils.isEmpty(version = version.trim()) && StringUtils.isEmpty(target.getVersion())) {
                                match = true;
                                break;
                            }
                            if (!version.equals(target.getVersion())) continue;
                            match = true;
                            break;
                        }
                        if (!match) {
                            return false;
                        }
                    } else if (!Objects.equals(rule.getVersion(), target.getVersion())) {
                        return false;
                    }
                }
            }
            if (!"*".equals(rule.getGroup())) {
                if (StringUtils.isEmpty(rule.getGroup()) && !StringUtils.isEmpty(target.getGroup())) {
                    return false;
                }
                if (!StringUtils.isEmpty(rule.getGroup())) {
                    if (rule.getGroup().contains(",")) {
                        String[] groups = rule.getGroup().split("\\,", -1);
                        match = false;
                        for (String group : groups) {
                            if (StringUtils.isEmpty(group = group.trim()) && StringUtils.isEmpty(target.getGroup())) {
                                match = true;
                                break;
                            }
                            if (!group.equals(target.getGroup())) continue;
                            match = true;
                            break;
                        }
                        if (!match) {
                            return false;
                        }
                    } else if (!Objects.equals(rule.getGroup(), target.getGroup())) {
                        return false;
                    }
                }
            }
            return true;
        }
    }
}

