/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.auth.filter;

import org.apache.dubbo.auth.spi.Authenticator;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.FrameworkModel;

@Activate(group={"provider"}, value={"auth"}, order=-10000)
public class ProviderAuthFilter
implements Filter {
    private final FrameworkModel frameworkModel;

    public ProviderAuthFilter(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        URL url = invoker.getUrl();
        boolean shouldAuth = url.getParameter("auth", false);
        if (shouldAuth) {
            if (Boolean.TRUE.equals(invocation.getAttributes().get("auth.success"))) {
                return invoker.invoke(invocation);
            }
            Authenticator authenticator = this.frameworkModel.getExtensionLoader(Authenticator.class).getExtension(url.getParameter("authenticator", "basic"));
            try {
                authenticator.authenticate(invocation, url);
            }
            catch (Exception e) {
                return AsyncRpcResult.newDefaultAsyncResult(e, invocation);
            }
        }
        return invoker.invoke(invocation);
    }
}

