/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.auth;

import org.apache.dubbo.auth.exception.AccessKeyNotFoundException;
import org.apache.dubbo.auth.exception.RpcAuthenticationException;
import org.apache.dubbo.auth.model.AccessKeyPair;
import org.apache.dubbo.auth.spi.AccessKeyStorage;
import org.apache.dubbo.auth.spi.Authenticator;
import org.apache.dubbo.auth.utils.SignatureUtils;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.support.RpcUtils;

public class AccessKeyAuthenticator
implements Authenticator {
    private final FrameworkModel frameworkModel;

    public AccessKeyAuthenticator(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    @Override
    public void sign(Invocation invocation, URL url) {
        String currentTime = String.valueOf(System.currentTimeMillis());
        AccessKeyPair accessKeyPair = this.getAccessKeyPair(invocation, url);
        invocation.setAttachment("signature", this.getSignature(url, invocation, accessKeyPair.getSecretKey(), currentTime));
        invocation.setAttachment("timestamp", currentTime);
        invocation.setAttachment("ak", accessKeyPair.getAccessKey());
        invocation.setAttachment("consumer", url.getApplication());
    }

    @Override
    public void authenticate(Invocation invocation, URL url) throws RpcAuthenticationException {
        AccessKeyPair accessKeyPair;
        String accessKeyId = String.valueOf(invocation.getAttachment("ak"));
        String requestTimestamp = String.valueOf(invocation.getAttachment("timestamp"));
        String originSignature = String.valueOf(invocation.getAttachment("signature"));
        String consumer = String.valueOf(invocation.getAttachment("consumer"));
        if (StringUtils.isAnyEmpty(accessKeyId, consumer, requestTimestamp, originSignature)) {
            throw new RpcAuthenticationException("Failed to authenticate, maybe consumer side did not enable the auth");
        }
        try {
            accessKeyPair = this.getAccessKeyPair(invocation, url);
        }
        catch (Exception e) {
            throw new RpcAuthenticationException("Failed to authenticate , can't load the accessKeyPair");
        }
        String computeSignature = this.getSignature(url, invocation, accessKeyPair.getSecretKey(), requestTimestamp);
        boolean success = computeSignature.equals(originSignature);
        if (!success) {
            throw new RpcAuthenticationException("Failed to authenticate, signature is not correct");
        }
    }

    AccessKeyPair getAccessKeyPair(Invocation invocation, URL url) {
        AccessKeyPair accessKeyPair;
        AccessKeyStorage accessKeyStorage = this.frameworkModel.getExtensionLoader(AccessKeyStorage.class).getExtension(url.getParameter("accessKey.storage", "urlstorage"));
        try {
            accessKeyPair = accessKeyStorage.getAccessKey(url, invocation);
            if (accessKeyPair == null || StringUtils.isAnyEmpty(accessKeyPair.getAccessKey(), accessKeyPair.getSecretKey())) {
                throw new AccessKeyNotFoundException("AccessKeyId or secretAccessKey not found");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can't load the AccessKeyPair from accessKeyStorage");
        }
        return accessKeyPair;
    }

    String getSignature(URL url, Invocation invocation, String secretKey, String time) {
        String requestString = String.format("%s#%s#%s#%s", url.getColonSeparatedKey(), RpcUtils.getMethodName(invocation), secretKey, time);
        return SignatureUtils.sign(requestString, secretKey);
    }
}

