/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.tools;

import com.github.os72.protobuf.dynamic.DynamicSchema;
import com.github.os72.protobuf.dynamic.MessageDefinition;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.util.List;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.testing.tools.EventSerializer;

public class ProtobufEventSerializer
implements EventSerializer {
    public static final String TYPE = "protobuf";
    private static final Logger LOGGER = new Logger(ProtobufEventSerializer.class);
    public static final DynamicSchema SCHEMA;

    @Override
    public byte[] serialize(List<Pair<String, Object>> event) {
        DynamicMessage.Builder builder = SCHEMA.newMessageBuilder("Wikipedia");
        Descriptors.Descriptor msgDesc = builder.getDescriptorForType();
        for (Pair<String, Object> pair : event) {
            builder.setField(msgDesc.findFieldByName((String)pair.lhs), pair.rhs);
        }
        return builder.build().toByteArray();
    }

    @Override
    public void close() {
    }

    static {
        DynamicSchema.Builder schemaBuilder = DynamicSchema.newBuilder();
        MessageDefinition wikiDef = MessageDefinition.newBuilder((String)"Wikipedia").addField("optional", "string", "timestamp", 1).addField("optional", "string", "page", 2).addField("optional", "string", "language", 3).addField("optional", "string", "user", 4).addField("optional", "string", "unpatrolled", 5).addField("optional", "string", "newPage", 6).addField("optional", "string", "robot", 7).addField("optional", "string", "anonymous", 8).addField("optional", "string", "namespace", 9).addField("optional", "string", "continent", 10).addField("optional", "string", "country", 11).addField("optional", "string", "region", 12).addField("optional", "string", "city", 13).addField("optional", "int32", "added", 14).addField("optional", "int32", "deleted", 15).addField("optional", "int32", "delta", 16).build();
        schemaBuilder.addMessageDefinition(wikiDef);
        DynamicSchema schema = null;
        try {
            schema = schemaBuilder.build();
        }
        catch (Descriptors.DescriptorValidationException e) {
            LOGGER.error("Could not init protobuf schema.", new Object[0]);
        }
        SCHEMA = schema;
    }
}

