/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.tools;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.testing.tools.AvroEventSerializer;
import org.apache.druid.testing.tools.IntegrationTestingConfig;
import org.apache.druid.testing.tools.KafkaUtil;

public class AvroSchemaRegistryEventSerializer
extends AvroEventSerializer {
    private static final int MAX_INITIALIZE_RETRIES = 10;
    public static final String TYPE = "avro-schema-registry";
    private final IntegrationTestingConfig config;
    private final CachedSchemaRegistryClient client;
    private int schemaId = -1;
    private Schema fromRegistry;

    public AvroSchemaRegistryEventSerializer(String schemaRegistryHost) {
        this.config = null;
        this.client = KafkaUtil.createSchemaRegistryClient(schemaRegistryHost);
    }

    @JsonCreator
    public AvroSchemaRegistryEventSerializer(@JacksonInject IntegrationTestingConfig config) {
        this.config = config;
        this.client = KafkaUtil.createSchemaRegistryClient(config.getSchemaRegistryHost());
    }

    @Override
    public void initialize(String topic) {
        try {
            RetryUtils.retry(() -> {
                this.schemaId = this.client.register(topic, AvroEventSerializer.SCHEMA);
                this.fromRegistry = this.client.getById(this.schemaId);
                return 0;
            }, e -> true, (int)10);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public byte[] serialize(List<Pair<String, Object>> event) throws IOException {
        AvroEventSerializer.WikipediaRecord record = new AvroEventSerializer.WikipediaRecord(this.fromRegistry);
        event.forEach(pair -> record.put((String)pair.lhs, pair.rhs));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(0);
        out.write(ByteBuffer.allocate(4).putInt(this.schemaId).array());
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)out, null);
        GenericDatumWriter writer = new GenericDatumWriter(this.fromRegistry);
        writer.write((Object)record, (Encoder)encoder);
        encoder.flush();
        byte[] bytes = out.toByteArray();
        out.close();
        return bytes;
    }
}

