/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

public class DoublesSketchToHistogramPostAggregator
implements PostAggregator {
    static final int DEFAULT_NUM_BINS = 10;
    private final String name;
    private final PostAggregator field;
    private final double[] splitPoints;
    private final Integer numBins;

    @JsonCreator
    public DoublesSketchToHistogramPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="field") PostAggregator field, @JsonProperty(value="splitPoints") @Nullable double[] splitPoints, @JsonProperty(value="numBins") @Nullable Integer numBins) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.field = (PostAggregator)Preconditions.checkNotNull((Object)field, (Object)"field is null");
        this.splitPoints = splitPoints;
        this.numBins = numBins;
        if (splitPoints != null && numBins != null) {
            throw new IAE("Cannot accept both 'splitPoints' and 'numBins'", new Object[0]);
        }
    }

    public Object compute(Map<String, Object> combinedAggregators) {
        double[] splitPoints;
        int numBins;
        DoublesSketch sketch = (DoublesSketch)this.field.compute(combinedAggregators);
        int n = this.splitPoints != null ? this.splitPoints.length + 1 : (numBins = this.numBins != null ? this.numBins : 10);
        if (numBins < 2) {
            throw new IAE("at least 2 bins expected", new Object[0]);
        }
        if (sketch.isEmpty()) {
            double[] histogram = new double[numBins];
            Arrays.fill(histogram, Double.NaN);
            return histogram;
        }
        if (this.splitPoints != null) {
            splitPoints = this.splitPoints;
        } else {
            double max;
            double min = sketch.getMinItem();
            if (min == (max = sketch.getMaxItem())) {
                double[] histogram = new double[numBins];
                histogram[0] = sketch.getN();
                return histogram;
            }
            splitPoints = DoublesSketchToHistogramPostAggregator.equallySpacedPoints(numBins, min, max);
        }
        double[] histogram = sketch.getPMF(splitPoints);
        int i = 0;
        while (i < histogram.length) {
            int n2 = i++;
            histogram[n2] = histogram[n2] * (double)sketch.getN();
        }
        return histogram;
    }

    private static double[] equallySpacedPoints(int num, double min, double max) {
        double[] points = new double[num - 1];
        double delta = (max - min) / (double)num;
        for (int i = 0; i < num - 1; ++i) {
            points[i] = min + delta * (double)(i + 1);
        }
        return points;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public ColumnType getType(ColumnInspector signature) {
        return ColumnType.DOUBLE_ARRAY;
    }

    @JsonProperty
    public PostAggregator getField() {
        return this.field;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public double[] getSplitPoints() {
        return this.splitPoints;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getNumBins() {
        return this.numBins;
    }

    public Comparator<double[]> getComparator() {
        throw new IAE("Comparing histograms is not supported", new Object[0]);
    }

    public Set<String> getDependentFields() {
        return this.field.getDependentFields();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + "', field=" + String.valueOf(this.field) + ", splitPoints=" + Arrays.toString(this.splitPoints) + ", numBins=" + this.numBins + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoublesSketchToHistogramPostAggregator that = (DoublesSketchToHistogramPostAggregator)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!Arrays.equals(this.splitPoints, that.splitPoints)) {
            return false;
        }
        if (!this.field.equals((Object)that.field)) {
            return false;
        }
        if (this.numBins == null && that.numBins == null) {
            return true;
        }
        return this.numBins != null && this.numBins.equals(that.numBins);
    }

    public int hashCode() {
        int hashCode = this.name.hashCode() * 31 + this.field.hashCode();
        hashCode = hashCode * 31 + Arrays.hashCode(this.splitPoints);
        if (this.numBins != null) {
            hashCode = hashCode * 31 + this.numBins.hashCode();
        }
        return hashCode;
    }

    public byte[] getCacheKey() {
        CacheKeyBuilder builder = new CacheKeyBuilder(29).appendCacheable((Cacheable)this.field);
        if (this.splitPoints != null) {
            for (double value : this.splitPoints) {
                builder.appendDouble(value);
            }
        }
        if (this.numBins != null) {
            builder.appendInt(this.numBins.intValue());
        }
        return builder.build();
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> map) {
        return this;
    }
}

