/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.kll;

import com.google.common.primitives.Doubles;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.query.aggregation.datasketches.kll.KllDoublesSketchObjectStrategy;
import org.apache.druid.query.aggregation.datasketches.kll.KllDoublesSketchOperations;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.ComplexMetricSerde;

public class KllDoublesSketchComplexMetricSerde
extends ComplexMetricSerde {
    private static final KllDoublesSketchObjectStrategy STRATEGY = new KllDoublesSketchObjectStrategy();

    public String getTypeName() {
        return "KllDoublesSketch";
    }

    public ObjectStrategy<KllDoublesSketch> getObjectStrategy() {
        return STRATEGY;
    }

    public ComplexMetricExtractor getExtractor() {
        return new ComplexMetricExtractor(){
            private static final int MIN_K = 8;

            public Class<?> extractedClass() {
                return KllDoublesSketch.class;
            }

            public Object extractValue(InputRow inputRow, String metricName) {
                Object object = inputRow.getRaw(metricName);
                if (object instanceof String) {
                    String objectString = (String)object;
                    if (objectString.isEmpty()) {
                        return KllDoublesSketchOperations.EMPTY_SKETCH;
                    }
                    Double doubleValue = Doubles.tryParse((String)objectString);
                    if (doubleValue != null) {
                        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance((int)8);
                        sketch.update(doubleValue.doubleValue());
                        return sketch;
                    }
                } else if (object instanceof Number) {
                    KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance((int)8);
                    sketch.update(((Number)object).doubleValue());
                    return sketch;
                }
                if (object == null || object instanceof KllDoublesSketch || object instanceof Memory) {
                    return object;
                }
                return KllDoublesSketchOperations.deserializeSafe(object);
            }
        };
    }
}

