/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.emitter.prometheus;

import io.prometheus.client.SimpleCollector;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Stopwatch;
import org.apache.druid.java.util.common.logger.Logger;
import org.joda.time.Duration;

public class DimensionsAndCollector {
    private static final Logger log = new Logger(DimensionsAndCollector.class);
    private final String[] dimensions;
    private final SimpleCollector collector;
    private final double conversionFactor;
    private final double[] histogramBuckets;
    private final Stopwatch updateTimer;
    private final Duration ttlSeconds;

    DimensionsAndCollector(String[] dimensions, SimpleCollector collector, double conversionFactor, double[] histogramBuckets, @Nullable Integer ttlSeconds) {
        this.dimensions = dimensions;
        this.collector = collector;
        this.conversionFactor = conversionFactor;
        this.histogramBuckets = histogramBuckets;
        this.updateTimer = Stopwatch.createStarted();
        this.ttlSeconds = ttlSeconds != null ? Duration.standardSeconds((long)ttlSeconds.intValue()) : null;
    }

    public String[] getDimensions() {
        return this.dimensions;
    }

    public SimpleCollector getCollector() {
        return this.collector;
    }

    public double getConversionFactor() {
        return this.conversionFactor;
    }

    public double[] getHistogramBuckets() {
        return this.histogramBuckets;
    }

    public void resetLastUpdateTime() {
        this.updateTimer.restart();
    }

    public long getMillisSinceLastUpdate() {
        return this.updateTimer.millisElapsed();
    }

    public boolean isExpired() {
        if (this.ttlSeconds == null) {
            log.error("Invalid usage of isExpired(), TTL has not been set", new Object[0]);
            return false;
        }
        return this.updateTimer.hasElapsed(this.ttlSeconds);
    }
}

