/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.samplers;

import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.trace.TraceState;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.samplers.ImmutableSamplingResult;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.samplers.SamplingDecision;

@Immutable
public interface SamplingResult {
    public static SamplingResult create(SamplingDecision decision) {
        switch (decision) {
            case RECORD_AND_SAMPLE: {
                return ImmutableSamplingResult.EMPTY_RECORDED_AND_SAMPLED_SAMPLING_RESULT;
            }
            case RECORD_ONLY: {
                return ImmutableSamplingResult.EMPTY_RECORDED_SAMPLING_RESULT;
            }
            case DROP: {
                return ImmutableSamplingResult.EMPTY_NOT_SAMPLED_OR_RECORDED_SAMPLING_RESULT;
            }
        }
        throw new AssertionError((Object)"unrecognised samplingResult");
    }

    public static SamplingResult create(SamplingDecision decision, Attributes attributes) {
        Objects.requireNonNull(attributes, "attributes");
        return attributes.isEmpty() ? SamplingResult.create(decision) : ImmutableSamplingResult.createSamplingResult(decision, attributes);
    }

    public static SamplingResult recordAndSample() {
        return ImmutableSamplingResult.EMPTY_RECORDED_AND_SAMPLED_SAMPLING_RESULT;
    }

    public static SamplingResult recordOnly() {
        return ImmutableSamplingResult.EMPTY_RECORDED_SAMPLING_RESULT;
    }

    public static SamplingResult drop() {
        return ImmutableSamplingResult.EMPTY_NOT_SAMPLED_OR_RECORDED_SAMPLING_RESULT;
    }

    public SamplingDecision getDecision();

    public Attributes getAttributes();

    default public TraceState getUpdatedTraceState(TraceState parentTraceState) {
        return parentTraceState;
    }
}

