/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.export;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.context.Context;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.ReadWriteSpan;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.ReadableSpan;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.SpanProcessor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.data.SpanData;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.export.SpanExporter;

public final class SimpleSpanProcessor
implements SpanProcessor {
    private static final Logger logger = Logger.getLogger(SimpleSpanProcessor.class.getName());
    private final SpanExporter spanExporter;
    private final boolean sampled;
    private final Set<CompletableResultCode> pendingExports = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    public static SpanProcessor create(SpanExporter exporter) {
        Objects.requireNonNull(exporter, "exporter");
        return new SimpleSpanProcessor(exporter, true);
    }

    SimpleSpanProcessor(SpanExporter spanExporter, boolean sampled) {
        this.spanExporter = Objects.requireNonNull(spanExporter, "spanExporter");
        this.sampled = sampled;
    }

    @Override
    public void onStart(Context parentContext, ReadWriteSpan span) {
    }

    @Override
    public boolean isStartRequired() {
        return false;
    }

    @Override
    public void onEnd(ReadableSpan span) {
        if (this.sampled && !span.getSpanContext().isSampled()) {
            return;
        }
        try {
            List<SpanData> spans = Collections.singletonList(span.toSpanData());
            CompletableResultCode result = this.spanExporter.export(spans);
            this.pendingExports.add(result);
            result.whenComplete(() -> {
                this.pendingExports.remove(result);
                if (!result.isSuccess()) {
                    logger.log(Level.FINE, "Exporter failed");
                }
            });
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "Exporter threw an Exception", e);
        }
    }

    @Override
    public boolean isEndRequired() {
        return true;
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        CompletableResultCode result = new CompletableResultCode();
        CompletableResultCode flushResult = this.forceFlush();
        flushResult.whenComplete(() -> {
            CompletableResultCode shutdownResult = this.spanExporter.shutdown();
            shutdownResult.whenComplete(() -> {
                if (!flushResult.isSuccess() || !shutdownResult.isSuccess()) {
                    result.fail();
                } else {
                    result.succeed();
                }
            });
        });
        return result;
    }

    @Override
    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofAll(this.pendingExports);
    }
}

