/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.common.Clock;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.resources.Resource;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.IdGenerator;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.SdkTracerProvider;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.SpanLimits;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.SpanProcessor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.samplers.Sampler;

public final class SdkTracerProviderBuilder {
    private static final Sampler DEFAULT_SAMPLER = Sampler.parentBased(Sampler.alwaysOn());
    private final List<SpanProcessor> spanProcessors = new ArrayList<SpanProcessor>();
    private Clock clock = Clock.getDefault();
    private IdGenerator idsGenerator = IdGenerator.random();
    private Resource resource = Resource.getDefault();
    private Supplier<SpanLimits> spanLimitsSupplier = SpanLimits::getDefault;
    private Sampler sampler = DEFAULT_SAMPLER;

    public SdkTracerProviderBuilder setClock(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    public SdkTracerProviderBuilder setIdGenerator(IdGenerator idGenerator) {
        Objects.requireNonNull(idGenerator, "idGenerator");
        this.idsGenerator = idGenerator;
        return this;
    }

    public SdkTracerProviderBuilder setResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = resource;
        return this;
    }

    public SdkTracerProviderBuilder setSpanLimits(SpanLimits spanLimits) {
        Objects.requireNonNull(spanLimits, "spanLimits");
        this.spanLimitsSupplier = () -> spanLimits;
        return this;
    }

    public SdkTracerProviderBuilder setSpanLimits(Supplier<SpanLimits> spanLimitsSupplier) {
        Objects.requireNonNull(spanLimitsSupplier, "spanLimitsSupplier");
        this.spanLimitsSupplier = spanLimitsSupplier;
        return this;
    }

    public SdkTracerProviderBuilder setSampler(Sampler sampler) {
        Objects.requireNonNull(sampler, "sampler");
        this.sampler = sampler;
        return this;
    }

    public SdkTracerProviderBuilder addSpanProcessor(SpanProcessor spanProcessor) {
        this.spanProcessors.add(spanProcessor);
        return this;
    }

    public SdkTracerProvider build() {
        return new SdkTracerProvider(this.clock, this.idsGenerator, this.resource, this.spanLimitsSupplier, this.sampler, this.spanProcessors);
    }

    SdkTracerProviderBuilder() {
    }
}

