/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace;

import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.trace.SpanBuilder;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.trace.Tracer;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.trace.TracerProvider;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.SdkSpanBuilder;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.TracerSharedState;

final class SdkTracer
implements Tracer {
    static final String FALLBACK_SPAN_NAME = "<unspecified span name>";
    private final TracerSharedState sharedState;
    private final InstrumentationLibraryInfo instrumentationLibraryInfo;

    SdkTracer(TracerSharedState sharedState, InstrumentationLibraryInfo instrumentationLibraryInfo) {
        this.sharedState = sharedState;
        this.instrumentationLibraryInfo = instrumentationLibraryInfo;
    }

    @Override
    public SpanBuilder spanBuilder(String spanName) {
        if (spanName == null || spanName.trim().isEmpty()) {
            spanName = FALLBACK_SPAN_NAME;
        }
        if (this.sharedState.hasBeenShutdown()) {
            Tracer tracer = TracerProvider.noop().get(this.instrumentationLibraryInfo.getName());
            return tracer.spanBuilder(spanName);
        }
        return new SdkSpanBuilder(spanName, this.instrumentationLibraryInfo, this.sharedState, this.sharedState.getSpanLimits());
    }

    InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return this.instrumentationLibraryInfo;
    }
}

