/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.common.AttributeKey;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.common.AttributesBuilder;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.trace.AttributeUtil;

final class AttributesMap
extends HashMap<AttributeKey<?>, Object>
implements Attributes {
    private static final long serialVersionUID = -5072696312123632376L;
    private final long capacity;
    private final int lengthLimit;
    private int totalAddedValues = 0;

    AttributesMap(long capacity, int lengthLimit) {
        this.capacity = capacity;
        this.lengthLimit = lengthLimit;
    }

    @Override
    <T> void put(AttributeKey<T> key, T value) {
        ++this.totalAddedValues;
        if ((long)this.size() >= this.capacity && !this.containsKey(key)) {
            return;
        }
        super.put(key, AttributeUtil.applyAttributeLengthLimit(value, this.lengthLimit));
    }

    int getTotalAddedValues() {
        return this.totalAddedValues;
    }

    @Override
    @Nullable
    public <T> T get(AttributeKey<T> key) {
        return (T)super.get(key);
    }

    @Override
    public Map<AttributeKey<?>, Object> asMap() {
        return Collections.unmodifiableMap(this);
    }

    @Override
    public AttributesBuilder toBuilder() {
        return Attributes.builder().putAll(this);
    }

    @Override
    public String toString() {
        return "AttributesMap{data=" + super.toString() + ", capacity=" + this.capacity + ", totalAddedValues=" + this.totalAddedValues + '}';
    }

    Attributes immutableCopy() {
        return Attributes.builder().putAll(this).build();
    }
}

