/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.view;

import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.common.Clock;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.internal.RandomSupplier;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.view.Aggregation;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.resources.Resource;

class SumAggregation
extends Aggregation {
    static final SumAggregation DEFAULT = new SumAggregation(AggregationTemporality.CUMULATIVE);
    private final AggregationTemporality temporality;

    SumAggregation(AggregationTemporality temporality) {
        this.temporality = temporality;
    }

    public AggregationTemporality getTemporality() {
        return this.temporality;
    }

    @Override
    public <T> Aggregator<T> createAggregator(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor instrumentDescriptor, MetricDescriptor metricDescriptor, ExemplarFilter exemplarFilter) {
        return AggregatorFactory.sum(this.temporality).create(resource, instrumentationLibraryInfo, instrumentDescriptor, metricDescriptor, () -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.fixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault())));
    }

    public String toString() {
        return "SumAggregation(" + (Object)((Object)this.temporality) + ")";
    }
}

