/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.view;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.internal.ThrottlingLogger;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.view.Aggregation;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.view.ExplicitBucketHistogramAggregation;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.view.LastValueAggregation;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.view.NoAggregation;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.view.SumAggregation;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.resources.Resource;

class DefaultAggregation
extends Aggregation {
    static final Aggregation INSTANCE = new DefaultAggregation();
    private static final ThrottlingLogger logger = new ThrottlingLogger(Logger.getLogger(DefaultAggregation.class.getName()));

    private DefaultAggregation() {
    }

    private static Aggregation resolve(InstrumentDescriptor instrument) {
        switch (instrument.getType()) {
            case COUNTER: 
            case UP_DOWN_COUNTER: 
            case OBSERVABLE_SUM: 
            case OBSERVABLE_UP_DOWN_SUM: {
                return SumAggregation.DEFAULT;
            }
            case HISTOGRAM: {
                return ExplicitBucketHistogramAggregation.DEFAULT;
            }
            case OBSERVABLE_GAUGE: {
                return LastValueAggregation.INSTANCE;
            }
        }
        logger.log(Level.WARNING, "Unable to find default aggregation for instrument: " + instrument);
        return NoAggregation.INSTANCE;
    }

    @Override
    public <T> Aggregator<T> createAggregator(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor instrumentDescriptor, MetricDescriptor metricDescriptor, ExemplarFilter exemplarFilter) {
        return DefaultAggregation.resolve(instrumentDescriptor).createAggregator(resource, instrumentationLibraryInfo, instrumentDescriptor, metricDescriptor, exemplarFilter);
    }

    public String toString() {
        return "DefaultAggregation";
    }
}

