/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.view;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.view.DefaultAggregation;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.view.ExplicitBucketHistogramAggregation;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.view.LastValueAggregation;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.view.NoAggregation;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.view.SumAggregation;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.resources.Resource;

public abstract class Aggregation {
    Aggregation() {
    }

    @Nullable
    public abstract <T> Aggregator<T> createAggregator(Resource var1, InstrumentationLibraryInfo var2, InstrumentDescriptor var3, MetricDescriptor var4, ExemplarFilter var5);

    public static Aggregation none() {
        return NoAggregation.INSTANCE;
    }

    public static Aggregation defaultAggregation() {
        return DefaultAggregation.INSTANCE;
    }

    public static Aggregation sum(AggregationTemporality temporality) {
        return new SumAggregation(temporality);
    }

    public static Aggregation sum() {
        return SumAggregation.DEFAULT;
    }

    public static Aggregation lastValue() {
        return LastValueAggregation.INSTANCE;
    }

    public static Aggregation explictBucketHistogram() {
        return ExplicitBucketHistogramAggregation.DEFAULT;
    }

    public static Aggregation explicitBucketHistogram(AggregationTemporality temporality) {
        return Aggregation.explicitBucketHistogram(temporality, ExplicitBucketHistogramUtils.DEFAULT_HISTOGRAM_BUCKET_BOUNDARIES);
    }

    public static Aggregation explicitBucketHistogram(AggregationTemporality temporality, List<Double> bucketBoundaries) {
        return new ExplicitBucketHistogramAggregation(temporality, bucketBoundaries);
    }

    public static Aggregation histogram() {
        return Aggregation.explictBucketHistogram();
    }
}

