/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.testing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.export.MetricExporter;

public final class InMemoryMetricExporter
implements MetricExporter {
    private final Queue<MetricData> finishedMetricItems = new LinkedBlockingQueue<MetricData>();
    private boolean isStopped = false;

    private InMemoryMetricExporter() {
    }

    public static InMemoryMetricExporter create() {
        return new InMemoryMetricExporter();
    }

    public List<MetricData> getFinishedMetricItems() {
        return Collections.unmodifiableList(new ArrayList<MetricData>(this.finishedMetricItems));
    }

    public void reset() {
        this.finishedMetricItems.clear();
    }

    @Override
    public CompletableResultCode export(Collection<MetricData> metrics) {
        if (this.isStopped) {
            return CompletableResultCode.ofFailure();
        }
        this.finishedMetricItems.addAll(metrics);
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        this.isStopped = true;
        this.finishedMetricItems.clear();
        return CompletableResultCode.ofSuccess();
    }
}

