/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.view.RegisteredView;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.view.ViewRegistryBuilder;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.view.InstrumentSelector;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.view.MeterSelector;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.view.View;

@Immutable
public final class ViewRegistry {
    static final View DEFAULT_VIEW = View.builder().build();
    private final List<RegisteredView> reverseRegistration;

    ViewRegistry(List<RegisteredView> reverseRegistration) {
        this.reverseRegistration = reverseRegistration;
    }

    public static ViewRegistryBuilder builder() {
        return new ViewRegistryBuilder();
    }

    public List<View> findViews(InstrumentDescriptor descriptor, InstrumentationLibraryInfo meter) {
        ArrayList<View> result = new ArrayList<View>();
        for (RegisteredView entry : this.reverseRegistration) {
            if (!ViewRegistry.matchesSelector(entry.getInstrumentSelector(), descriptor, meter)) continue;
            result.add(entry.getView());
        }
        if (result.isEmpty()) {
            return Collections.singletonList(DEFAULT_VIEW);
        }
        return Collections.unmodifiableList(result);
    }

    private static boolean matchesSelector(InstrumentSelector selector, InstrumentDescriptor descriptor, InstrumentationLibraryInfo meter) {
        return (selector.getInstrumentType() == null || selector.getInstrumentType() == descriptor.getType()) && selector.getInstrumentNameFilter().test(descriptor.getName()) && ViewRegistry.matchesMeter(selector.getMeterSelector(), meter);
    }

    private static boolean matchesMeter(MeterSelector selector, InstrumentationLibraryInfo meter) {
        return selector.getNameFilter().test(meter.getName()) && selector.getVersionFilter().test(meter.getVersion()) && selector.getSchemaUrlFilter().test(meter.getSchemaUrl());
    }
}

