/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.state.DuplicateMetricStorageException;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.state.MetricStorage;

public class MetricStorageRegistry {
    private final ConcurrentMap<String, MetricStorage> registry = new ConcurrentHashMap<String, MetricStorage>();

    public Collection<MetricStorage> getMetrics() {
        return Collections.unmodifiableCollection(new ArrayList(this.registry.values()));
    }

    public <I extends MetricStorage> I register(I storage) {
        MetricDescriptor descriptor = storage.getMetricDescriptor();
        MetricStorage oldOrNewStorage = this.registry.computeIfAbsent(descriptor.getName().toLowerCase(), key -> storage);
        if (!oldOrNewStorage.getMetricDescriptor().isCompatibleWith(descriptor)) {
            throw new DuplicateMetricStorageException(oldOrNewStorage.getMetricDescriptor(), descriptor, "Metric with same name and different descriptor already created.");
        }
        if (!storage.getClass().equals(oldOrNewStorage.getClass())) {
            throw new DuplicateMetricStorageException(oldOrNewStorage.getMetricDescriptor(), descriptor, "Metric with same name and different instrument already created.");
        }
        return (I)oldOrNewStorage;
    }
}

