/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.state;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.context.Context;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.export.CollectionHandle;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.state.BoundStorageHandle;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.state.DeltaMetricStorage;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.state.SynchronousMetricStorage;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.state.TemporalMetricStorage;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;

public final class DefaultSynchronousMetricStorage<T>
implements SynchronousMetricStorage {
    private final MetricDescriptor metricDescriptor;
    private final DeltaMetricStorage<T> deltaMetricStorage;
    private final TemporalMetricStorage<T> temporalMetricStorage;
    private final AttributesProcessor attributesProcessor;
    private final BoundStorageHandle lateBoundStorageHandle = new BoundStorageHandle(){

        @Override
        public void release() {
        }

        @Override
        public void recordLong(long value, Attributes attributes, Context context) {
            DefaultSynchronousMetricStorage.this.recordLong(value, attributes, context);
        }

        @Override
        public void recordDouble(double value, Attributes attributes, Context context) {
            DefaultSynchronousMetricStorage.this.recordDouble(value, attributes, context);
        }
    };

    DefaultSynchronousMetricStorage(MetricDescriptor metricDescriptor, Aggregator<T> aggregator, AttributesProcessor attributesProcessor) {
        this.attributesProcessor = attributesProcessor;
        this.metricDescriptor = metricDescriptor;
        this.deltaMetricStorage = new DeltaMetricStorage<T>(aggregator);
        this.temporalMetricStorage = new TemporalMetricStorage<T>(aggregator, true);
    }

    @Override
    public BoundStorageHandle bind(Attributes attributes) {
        Objects.requireNonNull(attributes, "attributes");
        if (this.attributesProcessor.usesContext()) {
            return this.lateBoundStorageHandle;
        }
        return this.deltaMetricStorage.bind(this.attributesProcessor.process(attributes, Context.current()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordLong(long value, Attributes attributes, Context context) {
        Objects.requireNonNull(attributes, "attributes");
        attributes = this.attributesProcessor.process(attributes, context);
        BoundStorageHandle handle = this.deltaMetricStorage.bind(attributes);
        try {
            handle.recordLong(value, attributes, context);
        }
        finally {
            handle.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordDouble(double value, Attributes attributes, Context context) {
        Objects.requireNonNull(attributes, "attributes");
        attributes = this.attributesProcessor.process(attributes, context);
        BoundStorageHandle handle = this.deltaMetricStorage.bind(attributes);
        try {
            handle.recordDouble(value, attributes, context);
        }
        finally {
            handle.release();
        }
    }

    @Override
    @Nullable
    public MetricData collectAndReset(CollectionHandle collector, Set<CollectionHandle> allCollectors, long startEpochNanos, long epochNanos, boolean suppressSynchronousCollection) {
        Map<Attributes, T> result = this.deltaMetricStorage.collectFor(collector, allCollectors, suppressSynchronousCollection);
        return this.temporalMetricStorage.buildMetricFor(collector, result, startEpochNanos, epochNanos);
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }
}

