/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.function.Supplier;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.DoubleSumAggregator;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.LongSumAggregator;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.resources.Resource;

final class SumAggregatorFactory
implements AggregatorFactory {
    private final AggregationTemporality temporality;

    SumAggregatorFactory(AggregationTemporality temporality) {
        this.temporality = temporality;
    }

    @Override
    public <T> Aggregator<T> create(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor instrumentDescriptor, MetricDescriptor metricDescriptor, Supplier<ExemplarReservoir> reservoirFactory) {
        switch (instrumentDescriptor.getValueType()) {
            case LONG: {
                return new LongSumAggregator(resource, instrumentationLibraryInfo, instrumentDescriptor, metricDescriptor, this.temporality, reservoirFactory);
            }
            case DOUBLE: {
                return new DoubleSumAggregator(resource, instrumentationLibraryInfo, instrumentDescriptor, metricDescriptor, this.temporality, reservoirFactory);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }
}

