/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.function.Supplier;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.DoubleMinMaxSumCountAggregator;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.LongMinMaxSumCountAggregator;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.resources.Resource;

final class MinMaxSumCountAggregatorFactory
implements AggregatorFactory {
    static final AggregatorFactory INSTANCE = new MinMaxSumCountAggregatorFactory();

    private MinMaxSumCountAggregatorFactory() {
    }

    @Override
    public <T> Aggregator<T> create(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor instrumentDescriptor, MetricDescriptor metricDescriptor, Supplier<ExemplarReservoir> reservoirSupplier) {
        switch (instrumentDescriptor.getValueType()) {
            case LONG: {
                return new LongMinMaxSumCountAggregator(resource, instrumentationLibraryInfo, metricDescriptor, reservoirSupplier);
            }
            case DOUBLE: {
                return new DoubleMinMaxSumCountAggregator(resource, instrumentationLibraryInfo, metricDescriptor, reservoirSupplier);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }
}

