/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.data.LongSumData;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AbstractSumAggregator;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.LongAccumulation;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.MetricDataUtils;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.resources.Resource;

final class LongSumAggregator
extends AbstractSumAggregator<LongAccumulation> {
    private final Supplier<ExemplarReservoir> reservoirSupplier;

    LongSumAggregator(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor instrumentDescriptor, MetricDescriptor metricDescriptor, AggregationTemporality temporality, Supplier<ExemplarReservoir> reservoirSupplier) {
        super(resource, instrumentationLibraryInfo, instrumentDescriptor, metricDescriptor, temporality);
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<LongAccumulation> createHandle() {
        return new Handle(this.reservoirSupplier.get());
    }

    @Override
    public LongAccumulation accumulateLong(long value) {
        return LongAccumulation.create(value);
    }

    @Override
    LongAccumulation mergeSum(LongAccumulation previousAccumulation, LongAccumulation accumulation) {
        return LongAccumulation.create(previousAccumulation.getValue() + accumulation.getValue(), accumulation.getExemplars());
    }

    @Override
    LongAccumulation mergeDiff(LongAccumulation previousAccumulation, LongAccumulation accumulation) {
        return LongAccumulation.create(accumulation.getValue() - previousAccumulation.getValue(), accumulation.getExemplars());
    }

    @Override
    public MetricData toMetricData(Map<Attributes, LongAccumulation> accumulationByLabels, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        MetricDescriptor descriptor = this.getMetricDescriptor();
        return MetricData.createLongSum(this.getResource(), this.getInstrumentationLibraryInfo(), descriptor.getName(), descriptor.getDescription(), descriptor.getUnit(), LongSumData.create(this.isMonotonic(), this.temporality(), MetricDataUtils.toLongPointList(accumulationByLabels, this.temporality() == AggregationTemporality.CUMULATIVE ? startEpochNanos : lastCollectionEpoch, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<LongAccumulation> {
        private final LongAdder current = new LongAdder();

        Handle(ExemplarReservoir exemplarReservoir) {
            super(exemplarReservoir);
        }

        @Override
        protected LongAccumulation doAccumulateThenReset(List<ExemplarData> exemplars) {
            return LongAccumulation.create(this.current.sumThenReset(), exemplars);
        }

        @Override
        public void doRecordLong(long value) {
            this.current.add(value);
        }
    }
}

