/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AbstractMinMaxSumCountAggregator;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.MinMaxSumCountAccumulation;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.resources.Resource;

@ThreadSafe
final class LongMinMaxSumCountAggregator
extends AbstractMinMaxSumCountAggregator {
    private final Supplier<ExemplarReservoir> reservoirSupplier;

    LongMinMaxSumCountAggregator(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, MetricDescriptor descriptor, Supplier<ExemplarReservoir> reservoirSupplier) {
        super(resource, instrumentationLibraryInfo, descriptor);
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<MinMaxSumCountAccumulation> createHandle() {
        return new Handle(this.reservoirSupplier.get());
    }

    @Override
    public MinMaxSumCountAccumulation accumulateLong(long value) {
        return MinMaxSumCountAccumulation.create(1L, value, value, value);
    }

    static final class Handle
    extends AggregatorHandle<MinMaxSumCountAccumulation> {
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private final LongState current = new LongState();

        Handle(ExemplarReservoir exemplarReservoir) {
            super(exemplarReservoir);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected MinMaxSumCountAccumulation doAccumulateThenReset(List<ExemplarData> exemplars) {
            this.lock.writeLock().lock();
            try {
                MinMaxSumCountAccumulation toReturn = MinMaxSumCountAccumulation.create(this.current.count, this.current.sum, this.current.min, this.current.max);
                this.current.reset();
                MinMaxSumCountAccumulation minMaxSumCountAccumulation = toReturn;
                return minMaxSumCountAccumulation;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @Override
        protected void doRecordLong(long value) {
            this.lock.writeLock().lock();
            try {
                this.current.record(value);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        private static final class LongState {
            private long count;
            private long sum;
            private long min;
            private long max;

            public LongState() {
                this.reset();
            }

            private void reset() {
                this.sum = 0L;
                this.count = 0L;
                this.min = Long.MAX_VALUE;
                this.max = Long.MIN_VALUE;
            }

            public void record(long value) {
                ++this.count;
                this.sum += value;
                this.min = Math.min(value, this.min);
                this.max = Math.max(value, this.max);
            }
        }
    }
}

