/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.function.Supplier;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.DoubleLastValueAggregator;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.LongLastValueAggregator;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.resources.Resource;

final class LastValueAggregatorFactory
implements AggregatorFactory {
    static final AggregatorFactory INSTANCE = new LastValueAggregatorFactory();

    private LastValueAggregatorFactory() {
    }

    @Override
    public <T> Aggregator<T> create(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor, MetricDescriptor metricDescriptor, Supplier<ExemplarReservoir> reservoirSupplier) {
        switch (descriptor.getValueType()) {
            case LONG: {
                return new LongLastValueAggregator(resource, instrumentationLibraryInfo, metricDescriptor, reservoirSupplier);
            }
            case DOUBLE: {
                return new DoubleLastValueAggregator(resource, instrumentationLibraryInfo, metricDescriptor, reservoirSupplier);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }
}

