/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.List;
import java.util.function.Supplier;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.DoubleHistogramAggregator;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.resources.Resource;

final class HistogramAggregatorFactory
implements AggregatorFactory {
    private final double[] boundaries;
    private final AggregationTemporality temporality;

    HistogramAggregatorFactory(List<Double> boundaries, AggregationTemporality temporality) {
        this.boundaries = ExplicitBucketHistogramUtils.createBoundaryArray(boundaries);
        this.temporality = temporality;
        for (double v : this.boundaries) {
            if (!Double.isNaN(v)) continue;
            throw new IllegalArgumentException("invalid bucket boundary: NaN");
        }
        for (int i = 1; i < this.boundaries.length; ++i) {
            if (!(this.boundaries[i - 1] >= this.boundaries[i])) continue;
            throw new IllegalArgumentException("invalid bucket boundary: " + this.boundaries[i - 1] + " >= " + this.boundaries[i]);
        }
        if (this.boundaries.length > 0) {
            if (this.boundaries[0] == Double.NEGATIVE_INFINITY) {
                throw new IllegalArgumentException("invalid bucket boundary: -Inf");
            }
            if (this.boundaries[this.boundaries.length - 1] == Double.POSITIVE_INFINITY) {
                throw new IllegalArgumentException("invalid bucket boundary: +Inf");
            }
        }
    }

    @Override
    public <T> Aggregator<T> create(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor instrumentDescriptor, MetricDescriptor metricDescriptor, Supplier<ExemplarReservoir> reservoirSupplier) {
        boolean stateful = this.temporality == AggregationTemporality.CUMULATIVE;
        switch (instrumentDescriptor.getValueType()) {
            case LONG: 
            case DOUBLE: {
                return new DoubleHistogramAggregator(resource, instrumentationLibraryInfo, metricDescriptor, this.boundaries, stateful, reservoirSupplier);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }
}

