/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.Arrays;
import java.util.List;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.HistogramAccumulation;

final class AutoValue_HistogramAccumulation
extends HistogramAccumulation {
    private final double sum;
    private final long[] counts;
    private final List<ExemplarData> exemplars;

    AutoValue_HistogramAccumulation(double sum, long[] counts, List<ExemplarData> exemplars) {
        this.sum = sum;
        if (counts == null) {
            throw new NullPointerException("Null counts");
        }
        this.counts = counts;
        if (exemplars == null) {
            throw new NullPointerException("Null exemplars");
        }
        this.exemplars = exemplars;
    }

    @Override
    double getSum() {
        return this.sum;
    }

    @Override
    long[] getCounts() {
        return this.counts;
    }

    @Override
    List<ExemplarData> getExemplars() {
        return this.exemplars;
    }

    public String toString() {
        return "HistogramAccumulation{sum=" + this.sum + ", counts=" + Arrays.toString(this.counts) + ", exemplars=" + this.exemplars + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HistogramAccumulation) {
            HistogramAccumulation that = (HistogramAccumulation)o;
            return Double.doubleToLongBits(this.sum) == Double.doubleToLongBits(that.getSum()) && Arrays.equals(this.counts, that instanceof AutoValue_HistogramAccumulation ? ((AutoValue_HistogramAccumulation)that).counts : that.getCounts()) && this.exemplars.equals(that.getExemplars());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.sum) >>> 32 ^ Double.doubleToLongBits(this.sum));
        h$ *= 1000003;
        h$ ^= Arrays.hashCode(this.counts);
        h$ *= 1000003;
        return h$ ^= this.exemplars.hashCode();
    }
}

