/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar;

import java.util.Random;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.context.Context;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.common.Clock;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar.AbstractFixedSizeExemplarReservoir;

final class FixedSizeExemplarReservoir
extends AbstractFixedSizeExemplarReservoir {
    private final Supplier<Random> randomSupplier;
    private final LongAdder numMeasurements = new LongAdder();

    public FixedSizeExemplarReservoir(Clock clock, int size, Supplier<Random> randomSupplier) {
        super(clock, size);
        this.randomSupplier = randomSupplier;
    }

    @Override
    protected int reservoirIndexFor(double value, Attributes attributes, Context context) {
        int count;
        int index = this.randomSupplier.get().nextInt((count = this.numMeasurements.intValue() + 1) > 0 ? count : 1);
        this.numMeasurements.increment();
        if (index < this.maxSize()) {
            return index;
        }
        return -1;
    }

    @Override
    protected void reset() {
        this.numMeasurements.reset();
    }
}

