/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar;

import java.util.List;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.context.Context;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;

class FilteredExemplarReservoir
implements ExemplarReservoir {
    private final ExemplarFilter filter;
    private final ExemplarReservoir reservoir;

    FilteredExemplarReservoir(ExemplarFilter filter, ExemplarReservoir reservoir) {
        this.filter = filter;
        this.reservoir = reservoir;
    }

    @Override
    public void offerMeasurement(long value, Attributes attributes, Context context) {
        if (this.filter.shouldSampleMeasurement(value, attributes, context)) {
            this.reservoir.offerMeasurement(value, attributes, context);
        }
    }

    @Override
    public void offerMeasurement(double value, Attributes attributes, Context context) {
        if (this.filter.shouldSampleMeasurement(value, attributes, context)) {
            this.reservoir.offerMeasurement(value, attributes, context);
        }
    }

    @Override
    public List<ExemplarData> collectAndReset(Attributes pointAttributes) {
        return this.reservoir.collectAndReset(pointAttributes);
    }
}

