/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar;

import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.context.Context;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.common.Clock;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar.FilteredExemplarReservoir;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar.FixedSizeExemplarReservoir;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar.HistogramBucketExemplarReservoir;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar.NoExemplarReservoir;

public interface ExemplarReservoir {
    public static ExemplarReservoir noSamples() {
        return NoExemplarReservoir.INSTANCE;
    }

    public static ExemplarReservoir filtered(ExemplarFilter filter, ExemplarReservoir original) {
        if (filter == ExemplarFilter.neverSample()) {
            return ExemplarReservoir.noSamples();
        }
        return new FilteredExemplarReservoir(filter, original);
    }

    public static ExemplarReservoir fixedSizeReservoir(Clock clock, int size, Supplier<Random> randomSupplier) {
        return new FixedSizeExemplarReservoir(clock, size, randomSupplier);
    }

    public static ExemplarReservoir histogramBucketReservoir(Clock clock, List<Double> boundaries) {
        return HistogramBucketExemplarReservoir.create(clock, boundaries);
    }

    public void offerMeasurement(long var1, Attributes var3, Context var4);

    public void offerMeasurement(double var1, Attributes var3, Context var4);

    public List<ExemplarData> collectAndReset(Attributes var1);
}

