/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.metrics.GlobalMeterProvider;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.common.Clock;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.DefaultSdkMeterProvider;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.NoopSdkMeterProvider;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.SdkMeterProvider;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.export.MetricReaderFactory;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.view.ViewRegistry;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.view.ViewRegistryBuilder;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.view.InstrumentSelector;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.view.View;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.resources.Resource;

public final class SdkMeterProviderBuilder {
    private Clock clock = Clock.getDefault();
    private Resource resource = Resource.getDefault();
    private final ViewRegistryBuilder viewRegistryBuilder = ViewRegistry.builder();
    private final List<MetricReaderFactory> metricReaders = new ArrayList<MetricReaderFactory>();
    private ExemplarFilter exemplarFilter = ExemplarFilter.sampleWithTraces();

    SdkMeterProviderBuilder() {
    }

    public SdkMeterProviderBuilder setClock(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    public SdkMeterProviderBuilder setResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = resource;
        return this;
    }

    public SdkMeterProviderBuilder setExemplarFilter(ExemplarFilter filter) {
        this.exemplarFilter = filter;
        return this;
    }

    public SdkMeterProviderBuilder registerView(InstrumentSelector selector, View view) {
        Objects.requireNonNull(selector, "selector");
        Objects.requireNonNull(view, "view");
        this.viewRegistryBuilder.addView(selector, view);
        return this;
    }

    public SdkMeterProvider buildAndRegisterGlobal() {
        SdkMeterProvider meterProvider = this.build();
        GlobalMeterProvider.set(meterProvider);
        return meterProvider;
    }

    public SdkMeterProviderBuilder registerMetricReader(MetricReaderFactory reader) {
        this.metricReaders.add(reader);
        return this;
    }

    public SdkMeterProvider build() {
        if (this.metricReaders.isEmpty()) {
            return new NoopSdkMeterProvider();
        }
        return new DefaultSdkMeterProvider(this.metricReaders, this.clock, this.resource, this.viewRegistryBuilder.build(), this.exemplarFilter);
    }
}

