/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics;

import java.util.function.Consumer;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.metrics.BoundLongUpDownCounter;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.metrics.DoubleUpDownCounterBuilder;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.metrics.LongUpDownCounter;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.metrics.ObservableLongMeasurement;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.context.Context;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.AbstractInstrument;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.AbstractInstrumentBuilder;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.SdkDoubleUpDownCounter;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.common.InstrumentType;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.state.BoundStorageHandle;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;

final class SdkLongUpDownCounter
extends AbstractInstrument
implements LongUpDownCounter {
    private final WriteableMetricStorage storage;

    private SdkLongUpDownCounter(InstrumentDescriptor descriptor, WriteableMetricStorage storage) {
        super(descriptor);
        this.storage = storage;
    }

    @Override
    public void add(long increment, Attributes attributes, Context context) {
        this.storage.recordLong(increment, attributes, context);
    }

    @Override
    public void add(long increment, Attributes attributes) {
        this.add(increment, attributes, Context.current());
    }

    @Override
    public void add(long increment) {
        this.add(increment, Attributes.empty());
    }

    @Override
    public BoundLongUpDownCounter bind(Attributes attributes) {
        return new BoundInstrument(this.storage.bind(attributes), attributes);
    }

    static final class BoundInstrument
    implements BoundLongUpDownCounter {
        private final BoundStorageHandle handle;
        private final Attributes attributes;

        BoundInstrument(BoundStorageHandle handle, Attributes attributes) {
            this.handle = handle;
            this.attributes = attributes;
        }

        @Override
        public void add(long increment, Context context) {
            this.handle.recordLong(increment, this.attributes, context);
        }

        @Override
        public void add(long increment) {
            this.add(increment, Context.current());
        }

        @Override
        public void unbind() {
            this.handle.release();
        }
    }

    static final class Builder
    extends AbstractInstrumentBuilder<Builder>
    implements LongUpDownCounterBuilder {
        Builder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, String name) {
            this(meterProviderSharedState, meterSharedState, name, "", "1");
        }

        Builder(MeterProviderSharedState meterProviderSharedState, MeterSharedState sharedState, String name, String description, String unit) {
            super(meterProviderSharedState, sharedState, name, description, unit);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public LongUpDownCounter build() {
            return this.buildSynchronousInstrument(InstrumentType.UP_DOWN_COUNTER, InstrumentValueType.LONG, (x$0, x$1) -> new SdkLongUpDownCounter((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        @Override
        public DoubleUpDownCounterBuilder ofDoubles() {
            return this.swapBuilder(SdkDoubleUpDownCounter.Builder::new);
        }

        @Override
        public void buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            this.registerLongAsynchronousInstrument(InstrumentType.OBSERVABLE_UP_DOWN_SUM, callback);
        }
    }
}

