/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.api.metrics.ObservableLongMeasurement;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.AbstractInstrument;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.common.InstrumentType;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import org.apache.druid.opentelemetry.shaded.io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;

public abstract class AbstractInstrumentBuilder<BuilderT extends AbstractInstrumentBuilder<?>> {
    private final MeterProviderSharedState meterProviderSharedState;
    private final MeterSharedState meterSharedState;
    private final String instrumentName;
    private String description;
    private String unit;

    AbstractInstrumentBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, String name, String description, String unit) {
        this.instrumentName = name;
        this.description = description;
        this.unit = unit;
        this.meterProviderSharedState = meterProviderSharedState;
        this.meterSharedState = meterSharedState;
    }

    protected abstract BuilderT getThis();

    public BuilderT setUnit(String unit) {
        this.unit = unit;
        return this.getThis();
    }

    public BuilderT setDescription(String description) {
        this.description = description;
        return this.getThis();
    }

    private InstrumentDescriptor makeDescriptor(InstrumentType type, InstrumentValueType valueType) {
        return InstrumentDescriptor.create(this.instrumentName, this.description, this.unit, type, valueType);
    }

    protected <T> T swapBuilder(SwapBuilder<T> swapper) {
        return swapper.newBuilder(this.meterProviderSharedState, this.meterSharedState, this.instrumentName, this.description, this.unit);
    }

    final <I extends AbstractInstrument> I buildSynchronousInstrument(InstrumentType type, InstrumentValueType valueType, BiFunction<InstrumentDescriptor, WriteableMetricStorage, I> instrumentFactory) {
        InstrumentDescriptor descriptor = this.makeDescriptor(type, valueType);
        WriteableMetricStorage storage = this.meterSharedState.registerSynchronousMetricStorage(descriptor, this.meterProviderSharedState);
        return (I)((AbstractInstrument)instrumentFactory.apply(descriptor, storage));
    }

    final void registerDoubleAsynchronousInstrument(InstrumentType type, Consumer<ObservableDoubleMeasurement> updater) {
        InstrumentDescriptor descriptor = this.makeDescriptor(type, InstrumentValueType.DOUBLE);
        this.meterSharedState.registerDoubleAsynchronousInstrument(descriptor, this.meterProviderSharedState, updater);
    }

    final void registerLongAsynchronousInstrument(InstrumentType type, Consumer<ObservableLongMeasurement> updater) {
        InstrumentDescriptor descriptor = this.makeDescriptor(type, InstrumentValueType.LONG);
        this.meterSharedState.registerLongAsynchronousInstrument(descriptor, this.meterProviderSharedState, updater);
    }

    @FunctionalInterface
    protected static interface SwapBuilder<T> {
        public T newBuilder(MeterProviderSharedState var1, MeterSharedState var2, String var3, String var4, String var5);
    }
}

